/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views.cloneview.highlighting;

import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcfviewer.util.Colors;
import de.uni_bremen.st.rcfviewer.util.sourceCode.SourceCodeWrapper;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.FileHighlighting;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.FontStyle;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.Highlighting;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.HighlightingTreeSet;
import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.TokenHighlighting;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IToken;
import org.eclipse.swt.graphics.Color;

public class HighlightingCalculator
implements Callable<FileHighlighting> {
    private List<Fragment> fragments;
    private SourceCodeWrapper sourceCodeWrapper;
    private Map<Integer, IToken> diffedTokens;

    public void set(List<Fragment> fragments, SourceCodeWrapper sourceCodeWrapper, Map<Integer, IToken> diffedTokens) {
        this.fragments = fragments;
        this.sourceCodeWrapper = sourceCodeWrapper;
        this.diffedTokens = diffedTokens;
    }

    @Override
    public FileHighlighting call() throws Exception {
        HighlightingTreeSet<TokenHighlighting> tokenHighlightings = new HighlightingTreeSet<TokenHighlighting>();
        HighlightingTreeSet<Highlighting> backgroundHighlightings = new HighlightingTreeSet<Highlighting>();
        TreeSet<Highlighting> fragmentRanges = new TreeSet<Highlighting>();
        String code = this.sourceCodeWrapper.getCode();
        tokenHighlightings.add(new TokenHighlighting(0, code.length(), Colors.COMMENT_COLOR, Colors.DEFAULT_BACKGROUND_COLOR, FontStyle.NORMAL));
        for (Fragment fragment : this.fragments) {
            int type = fragment.getCloneClasses().get(0).getType();
            Color cloneColor = Colors.getCloneColorFromType(type);
            TokenHighlighting highlighting = new TokenHighlighting(fragment.getStart().getOffset(), fragment.getEnd().getOffset() + 1, null, cloneColor, null);
            tokenHighlightings.add(highlighting);
        }
        for (Fragment fragment : this.fragments) {
            List<IToken> tokens = this.sourceCodeWrapper.getToken(fragment);
            int type = fragment.getCloneClasses().get(0).getType();
            Color cloneColor = Colors.getCloneColorFromType(type);
            for (IToken token : tokens) {
                FontStyle fontStyle = FontStyle.NORMAL;
                Color foregroundColor = Colors.DEFAULT_TEXT_COLOR;
                if (token.getType().isKeyword()) {
                    fontStyle = FontStyle.BOLD;
                    foregroundColor = Colors.KEYWORD_COLOR;
                } else if (token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT) {
                    foregroundColor = Colors.COMMENT_COLOR;
                } else if (token.getType().isLiteral()) {
                    foregroundColor = Colors.LITERAL_COLOR;
                }
                Color backgroundColor = cloneColor;
                if (null != this.diffedTokens.get(token.getOffset())) {
                    backgroundColor = Colors.DIFF_COLOR;
                }
                TokenHighlighting highlighting = new TokenHighlighting(token.getOffset(), token.getEndOffset() + 1, foregroundColor, backgroundColor, fontStyle);
                tokenHighlightings.add(highlighting);
            }
        }
        for (Fragment fragment : this.fragments) {
            int type = fragment.getCloneClasses().get(0).getType();
            Color cloneColor = Colors.getCloneColorFromType(type);
            int start = fragment.getStart().getOffset();
            int end = fragment.getEnd().getOffset() + 1;
            Highlighting background = new Highlighting(start, end, cloneColor);
            fragmentRanges.add(background.copy(Colors.getRulerColor(type)));
            int startLine = (Integer)this.sourceCodeWrapper.getOffsetCounter().countLineAndColumn((int)start).first;
            int endLine = (Integer)this.sourceCodeWrapper.getOffsetCounter().countLineAndColumn((int)(end - 1)).first;
            if (endLine > startLine) {
                int offsetOfEndLine = this.sourceCodeWrapper.getOffsetCounter().getOffset(endLine, 1);
                background = background.copy(start, --offsetOfEndLine);
            }
            backgroundHighlightings.add(background);
        }
        return new FileHighlighting(this.sourceCodeWrapper.getFile().getName(), code, tokenHighlightings, backgroundHighlightings, fragmentRanges);
    }
}

