/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcfviewer.views.cloneview.highlighting;

import de.uni_bremen.st.rcfviewer.views.cloneview.highlighting.OffsetPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class HighlightingTreeSet<T extends OffsetPosition>
implements Iterable<T> {
    private final SortedSet<OffsetPosition> highlightings = new TreeSet<OffsetPosition>();

    public void add(T t) {
        this.modify(t);
        this.highlightings.add((OffsetPosition)t);
    }

    public void modify(T t) {
        OffsetPosition follower;
        SortedSet<OffsetPosition> headSet = this.highlightings.headSet((OffsetPosition)t);
        SortedSet<OffsetPosition> tailSet = this.highlightings.tailSet((OffsetPosition)t);
        if (headSet.size() > 0) {
            OffsetPosition precursor = headSet.last();
            if (precursor.getEnd() > t.getEnd()) {
                this.highlightings.remove(precursor);
                OffsetPosition follower2 = precursor.copy(t.getEnd(), precursor.getEnd());
                this.highlightings.add(follower2);
                precursor = precursor.copy(precursor.getStart(), t.getStart());
                this.highlightings.add(precursor);
            } else if (precursor.getEnd() > t.getStart()) {
                this.highlightings.remove(precursor);
                precursor = precursor.copy(precursor.getStart(), t.getStart());
                this.highlightings.add(precursor);
            }
        }
        Iterator followerIterator = tailSet.iterator();
        ArrayList<OffsetPosition> addAfterIteration = new ArrayList<OffsetPosition>();
        while (followerIterator.hasNext() && (follower = (OffsetPosition)followerIterator.next()).getStart() < t.getEnd()) {
            if (follower.getEnd() <= t.getEnd()) {
                followerIterator.remove();
                continue;
            }
            followerIterator.remove();
            addAfterIteration.add(follower.copy(t.getEnd(), follower.getEnd()));
        }
        this.highlightings.addAll(addAfterIteration);
    }

    public void add(Collection<T> ts) {
        for (OffsetPosition t : ts) {
            this.add(t);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.highlightings.iterator();
    }

    public int size() {
        return this.highlightings.size();
    }
}

