/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOError;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import net.kotek.jdbm.BTree;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.RecordListener;
import net.kotek.jdbm.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTreeSortedMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V> {
    protected final BTree<K, V> tree;
    protected final K fromKey;
    protected final K toKey;
    protected final boolean readonly;
    private final Set<Map.Entry<K, V>> _entrySet = new AbstractSet<Map.Entry<K, V>>(){

        protected Map.Entry<K, V> newEntry(K k, V v) {
            return new AbstractMap.SimpleEntry<K, V>(k, v){
                private static final long serialVersionUID = 978651696969194154L;

                @Override
                public V setValue(V arg0) {
                    BTreeSortedMap.this.put(this.getKey(), arg0);
                    return super.setValue(arg0);
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            if (BTreeSortedMap.this.readonly) {
                throw new UnsupportedOperationException("readonly");
            }
            try {
                if (e.getKey() == null) {
                    throw new NullPointerException("Can not add null key");
                }
                if (!BTreeSortedMap.this.inBounds(e.getKey())) {
                    throw new IllegalArgumentException("key outside of bounds");
                }
                return BTreeSortedMap.this.tree.insert(e.getKey(), e.getValue(), true) == null;
            }
            catch (IOException e1) {
                throw new IOError(e1);
            }
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                try {
                    if (!BTreeSortedMap.this.inBounds(e.getKey())) {
                        return false;
                    }
                    if (e.getKey() != null && BTreeSortedMap.this.tree.get(e.getKey()) != null) {
                        return true;
                    }
                }
                catch (IOException e1) {
                    throw new IOError(e1);
                }
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            try {
                final BTree.BTreeTupleBrowser br = BTreeSortedMap.this.fromKey == null ? BTreeSortedMap.this.tree.browse() : BTreeSortedMap.this.tree.browse(BTreeSortedMap.this.fromKey);
                return new Iterator<Map.Entry<K, V>>(){
                    private Map.Entry<K, V> next;
                    private K lastKey;
                    {
                        this.ensureNext();
                    }

                    void ensureNext() {
                        try {
                            BTree.BTreeTuple t = new BTree.BTreeTuple();
                            this.next = br.getNext(t) && BTreeSortedMap.this.inBounds(t.key) ? this.newEntry(t.key, t.value) : null;
                        }
                        catch (IOException e1) {
                            throw new IOError(e1);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Map.Entry ret = this.next;
                        this.lastKey = ret.getKey();
                        this.ensureNext();
                        return ret;
                    }

                    @Override
                    public void remove() {
                        if (BTreeSortedMap.this.readonly) {
                            throw new UnsupportedOperationException("readonly");
                        }
                        if (this.lastKey == null) {
                            throw new IllegalStateException();
                        }
                        try {
                            br.remove(this.lastKey);
                            this.lastKey = null;
                        }
                        catch (IOException e1) {
                            throw new IOError(e1);
                        }
                    }
                };
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        @Override
        public boolean remove(Object o) {
            if (BTreeSortedMap.this.readonly) {
                throw new UnsupportedOperationException("readonly");
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                try {
                    if (e.getKey() == null || e.getValue() == null) {
                        return false;
                    }
                    if (!BTreeSortedMap.this.inBounds(e.getKey())) {
                        throw new IllegalArgumentException("out of bounds");
                    }
                    Object v = BTreeSortedMap.this.get(e.getKey());
                    if (v == null || !e.getValue().equals(v)) {
                        return false;
                    }
                    Object v2 = BTreeSortedMap.this.tree.remove(e.getKey());
                    return v2 != null;
                }
                catch (IOException e1) {
                    throw new IOError(e1);
                }
            }
            return false;
        }

        @Override
        public int size() {
            return BTreeSortedMap.this.size();
        }
    };

    public BTreeSortedMap(BTree<K, V> tree, boolean readonly) {
        this(tree, readonly, null, null);
    }

    protected BTreeSortedMap(BTree<K, V> tree, boolean readonly, K fromKey, K toKey) {
        this.tree = tree;
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.readonly = readonly;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._entrySet;
    }

    public boolean inBounds(K e) {
        Comparator comp = this.comparator();
        if (comp == null) {
            comp = Utils.COMPARABLE_COMPARATOR;
        }
        if (this.fromKey != null && comp.compare(e, this.fromKey) < 0) {
            return false;
        }
        return this.toKey == null || comp.compare(e, this.toKey) < 0;
    }

    @Override
    public V get(Object key) {
        try {
            if (key == null) {
                return null;
            }
            if (!this.inBounds(key)) {
                return null;
            }
            return this.tree.get(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public V remove(Object key) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        try {
            if (key == null || this.tree.get(key) == null) {
                return null;
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("out of bounds");
            }
            return this.tree.remove(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public V put(K key, V value) {
        if (this.readonly) {
            throw new UnsupportedOperationException("readonly");
        }
        try {
            if (key == null || value == null) {
                throw new NullPointerException("Null key or value");
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("out of bounds");
            }
            return this.tree.insert(key, value, true);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        try {
            if (!this.inBounds(key)) {
                return false;
            }
            V v = this.tree.get(key);
            return v != null;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.tree._comparator;
    }

    @Override
    public K firstKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        try {
            BTree.BTreeTupleBrowser b = this.fromKey == null ? this.tree.browse() : this.tree.browse(this.fromKey);
            BTree.BTreeTuple t = new BTree.BTreeTuple();
            b.getNext(t);
            return t.key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public K lastKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        try {
            BTree.BTreeTupleBrowser b = this.toKey == null ? this.tree.browse(null) : this.tree.browse(this.toKey);
            BTree.BTreeTuple t = new BTree.BTreeTuple();
            b.getPrevious(t);
            return t.key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return new BTreeSortedMap<Object, V>(this.tree, this.readonly, null, toKey);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        Comparator comp = this.comparator();
        if (comp == null) {
            comp = Utils.COMPARABLE_COMPARATOR;
        }
        if (comp.compare(fromKey, toKey) > 0) {
            throw new IllegalArgumentException("fromKey is bigger then toKey");
        }
        return new BTreeSortedMap<K, V>(this.tree, this.readonly, fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new BTreeSortedMap<Object, V>(this.tree, this.readonly, fromKey, null);
    }

    public BTree<K, V> getTree() {
        return this.tree;
    }

    public void addRecordListener(RecordListener<K, V> listener) {
        this.tree.addRecordListener(listener);
    }

    public DBAbstract getRecordManager() {
        return this.tree.getRecordManager();
    }

    public void removeRecordListener(RecordListener<K, V> listener) {
        this.tree.removeRecordListener(listener);
    }

    public Integer newIntegerKey() {
        if (this.isEmpty()) {
            return 0;
        }
        K k = this.lastKey();
        return (Integer)k + 1;
    }

    public Long newLongKey() {
        if (this.isEmpty()) {
            return 0L;
        }
        K k = this.lastKey();
        return (Long)k + 1L;
    }

    @Override
    public int size() {
        if (this.fromKey == null && this.toKey == null) {
            return this.tree.size();
        }
        Iterator iter = this.keySet().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            iter.next();
            ++counter;
        }
        return counter;
    }
}

