/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOError;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.DBStore;
import net.kotek.jdbm.LongHashMap;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBCache
extends DBAbstract {
    static final byte NONE = 1;
    static final byte MRU = 2;
    static final byte WEAK = 3;
    static final byte SOFT = 4;
    static final byte HARD = 5;
    private static final boolean debug = false;
    protected DBStore _db;
    protected LongHashMap<CacheEntry> _hash;
    protected LongHashMap _softHash;
    protected ReferenceQueue<ReferenceCacheEntry> _refQueue;
    protected int _max;
    protected Thread _softRefThread;
    protected static int threadCounter = 0;
    protected CacheEntry _first;
    protected CacheEntry _last;
    protected int insertCounter = 0;
    private boolean _autoClearReferenceCacheOnLowMem;
    private byte _cacheType;

    public DBCache(DBStore db, int maxRecords, byte cacheType, boolean autoClearReferenceCacheOnLowMem) {
        if (db == null) {
            throw new IllegalArgumentException("Argument 'db' is null");
        }
        this._hash = new LongHashMap(maxRecords);
        this._db = db;
        this._max = maxRecords;
        this._cacheType = cacheType;
        this._autoClearReferenceCacheOnLowMem = autoClearReferenceCacheOnLowMem;
        if (cacheType > 2) {
            this._softHash = new LongHashMap();
            this._refQueue = new ReferenceQueue();
            this._softRefThread = new Thread((Runnable)new SoftRunnable(this, this._refQueue), "JDBM Soft Cache Disposer " + threadCounter++);
            this._softRefThread.setDaemon(true);
            this._softRefThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> long insert(A obj, Serializer<A> serializer, boolean disableCache) throws IOException {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        if (this._db.needsAutoCommit()) {
            this.commit();
        }
        long recid = this._db.insert(obj, serializer, disableCache);
        if (disableCache) {
            return recid;
        }
        if (this._cacheType > 2) {
            LongHashMap longHashMap = this._softHash;
            synchronized (longHashMap) {
                if (this._cacheType == 4) {
                    this._softHash.put(recid, new SoftCacheEntry(recid, obj, this._refQueue));
                } else if (this._cacheType == 3) {
                    this._softHash.put(recid, new WeakCacheEntry(recid, obj, this._refQueue));
                } else {
                    this._softHash.put(recid, obj);
                }
            }
        } else {
            this.cachePut(recid, obj, serializer, false);
        }
        return recid;
    }

    void clearCacheIfLowOnMem() {
        this.insertCounter = 0;
        if (!this._autoClearReferenceCacheOnLowMem) {
            return;
        }
        Runtime r = Runtime.getRuntime();
        long max = r.maxMemory();
        if (max == Long.MAX_VALUE) {
            return;
        }
        double free = r.freeMemory();
        double total = r.totalMemory();
        if ((free += (double)max - total) < 1.0E7 || free * 4.0 < (double)max) {
            this.clearCache();
        }
    }

    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer, boolean disableCache) throws IOException {
        if (disableCache) {
            return this._db.fetch(recid, serializer, disableCache);
        }
        return this.fetch(recid, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void delete(long recid) throws IOException {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        if (this._db.needsAutoCommit()) {
            this.commit();
        }
        this._db.delete(recid);
        LongHashMap longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this._hash.get(recid);
            if (entry != null) {
                this.removeEntry(entry);
                this._hash.remove(entry._recid);
            }
        }
        if (this._cacheType > 2) {
            longHashMap = this._softHash;
            synchronized (longHashMap) {
                Object e = this._softHash.remove(recid);
                if (e != null && e instanceof ReferenceCacheEntry) {
                    ((ReferenceCacheEntry)e).clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> void update(long recid, A obj, Serializer<A> serializer) throws IOException {
        LongHashMap<CacheEntry> longHashMap;
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        if (this._db.needsAutoCommit()) {
            this.commit();
        }
        if (this._cacheType > 2) {
            longHashMap = this._softHash;
            synchronized (longHashMap) {
                Object e = this._softHash.remove(recid);
                if (e != null && e instanceof ReferenceCacheEntry) {
                    ((ReferenceCacheEntry)e).clear();
                }
            }
        }
        longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this.cacheGet(recid);
            if (entry != null) {
                entry._obj = obj;
                entry._serializer = serializer;
                entry._isDirty = true;
            } else {
                this.cachePut(recid, obj, serializer, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer) throws IOException {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        if (this._cacheType > 2) {
            LongHashMap longHashMap = this._softHash;
            synchronized (longHashMap) {
                Object e = this._softHash.get(recid);
                if (e != null) {
                    if (e instanceof ReferenceCacheEntry) {
                        e = ((ReferenceCacheEntry)e).get();
                    }
                    if (e != null) {
                        return (A)e;
                    }
                }
            }
        } else {
            CacheEntry entry = this.cacheGet(recid);
            if (entry != null) {
                return (A)entry._obj;
            }
        }
        A value = this._db.fetch(recid, serializer);
        if (this._cacheType == 2) {
            this.cachePut(recid, value, serializer, false);
        } else {
            LongHashMap longHashMap = this._softHash;
            synchronized (longHashMap) {
                if (this._cacheType == 4) {
                    this._softHash.put(recid, new SoftCacheEntry(recid, value, this._refQueue));
                } else if (this._cacheType == 3) {
                    this._softHash.put(recid, new WeakCacheEntry(recid, value, this._refQueue));
                } else {
                    this._softHash.put(recid, value);
                }
            }
        }
        return value;
    }

    @Override
    public synchronized void close() {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        this.updateCacheEntries();
        this._db.close();
        this._db = null;
        this._hash = null;
        this._softHash = null;
        if (this._cacheType > 2) {
            this._softRefThread.interrupt();
        }
    }

    @Override
    public synchronized void commit() {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        this.updateCacheEntries();
        this._db.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        this._db.rollback();
        LongHashMap longHashMap = this._hash;
        synchronized (longHashMap) {
            this._hash.clear();
            this._first = null;
            this._last = null;
        }
        if (this._cacheType > 2) {
            longHashMap = this._softHash;
            synchronized (longHashMap) {
                Iterator iter = this._softHash.valuesIterator();
                while (iter.hasNext()) {
                    ReferenceCacheEntry e = (ReferenceCacheEntry)iter.next();
                    e.clear();
                }
                this._softHash.clear();
            }
        }
    }

    @Override
    public synchronized long getNamedObject(String name) throws IOException {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        return this._db.getNamedObject(name);
    }

    @Override
    public synchronized void setNamedObject(String name, long recid) throws IOException {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        this._db.setNamedObject(name, recid);
    }

    @Override
    public Serializer defaultSerializer() {
        return this._db.defaultSerializer();
    }

    @Override
    public String calculateStatistics() {
        if (this._db == null) {
            throw new IllegalStateException("DB has been closed");
        }
        return this._db.calculateStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheEntries() {
        try {
            LongHashMap<CacheEntry> longHashMap = this._hash;
            synchronized (longHashMap) {
                CacheEntry[] vals = new CacheEntry[this._hash.size()];
                Iterator<CacheEntry> iter = this._hash.valuesIterator();
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = iter.next();
                }
                iter = null;
                for (CacheEntry entry : vals) {
                    if (!entry._isDirty) continue;
                    this._db.update(entry._recid, entry._obj, entry._serializer);
                    entry._isDirty = false;
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry cacheGet(long key) {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this._hash.get(key);
            if (this._cacheType <= 2 && entry != null && this._last != entry) {
                this.removeEntry(entry);
                this.addEntry(entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cachePut(long recid, Object value, Serializer serializer, boolean dirty) throws IOException {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this._hash.get(recid);
            if (entry != null) {
                entry._obj = value;
                entry._serializer = serializer;
                if (this._last != entry) {
                    this.removeEntry(entry);
                    this.addEntry(entry);
                }
            } else {
                if (this._hash.size() == this._max) {
                    entry = this.purgeEntry();
                    entry._recid = recid;
                    entry._obj = value;
                    entry._isDirty = dirty;
                    entry._serializer = serializer;
                } else {
                    entry = new CacheEntry(recid, value, serializer, dirty);
                }
                this.addEntry(entry);
                this._hash.put(entry._recid, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEntry(CacheEntry entry) {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            if (this._first == null) {
                this._first = entry;
                this._last = entry;
            } else {
                this._last._next = entry;
                entry._previous = this._last;
                this._last = entry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEntry(CacheEntry entry) {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            if (entry == this._first) {
                this._first = entry._next;
            }
            if (this._last == entry) {
                this._last = entry._previous;
            }
            CacheEntry previous = entry._previous;
            CacheEntry next = entry._next;
            if (previous != null) {
                previous._next = next;
            }
            if (next != null) {
                next._previous = previous;
            }
            entry._previous = null;
            entry._next = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry purgeEntry() {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this._first;
            if (entry == null) {
                return new CacheEntry(-1L, null, null, false);
            }
            if (entry._isDirty) {
                try {
                    this._db.update(entry._recid, entry._obj, entry._serializer);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            this.removeEntry(entry);
            this._hash.remove(entry._recid);
            entry._obj = null;
            entry._serializer = null;
            entry._isDirty = false;
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        LongHashMap longHashMap = this._hash;
        synchronized (longHashMap) {
            while (this._hash.size() > 0) {
                this.purgeEntry();
            }
            this._first = null;
            this._last = null;
        }
        if (this._cacheType > 2) {
            longHashMap = this._softHash;
            synchronized (longHashMap) {
                if (this._cacheType != 5) {
                    Iterator iter = this._softHash.valuesIterator();
                    while (iter.hasNext()) {
                        ReferenceCacheEntry e = (ReferenceCacheEntry)iter.next();
                        e.clear();
                    }
                }
                this._softHash.clear();
            }
        }
    }

    @Override
    public void defrag() {
        this.commit();
        this._db.defrag();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SoftRunnable
    implements Runnable {
        private ReferenceQueue<ReferenceCacheEntry> entryQueue;
        private WeakReference<DBCache> db2;

        public SoftRunnable(DBCache db, ReferenceQueue<ReferenceCacheEntry> entryQueue) {
            this.db2 = new WeakReference<DBCache>(db);
            this.entryQueue = entryQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: while (true) {
                try {
                    while (true) {
                        ReferenceCacheEntry e = (ReferenceCacheEntry)((Object)this.entryQueue.remove(10000L));
                        DBCache db = (DBCache)this.db2.get();
                        if (db == null) {
                            return;
                        }
                        if (e != null) {
                            LongHashMap longHashMap = db._softHash;
                            synchronized (longHashMap) {
                                boolean counter = false;
                                while (e != null) {
                                    db._softHash.remove(e.getRecid());
                                    e = (SoftCacheEntry)this.entryQueue.poll();
                                }
                                continue block6;
                            }
                        }
                        db.clearCacheIfLowOnMem();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static final class WeakCacheEntry
    extends WeakReference
    implements ReferenceCacheEntry {
        protected final long _recid;

        public long getRecid() {
            return this._recid;
        }

        WeakCacheEntry(long recid, Object obj, ReferenceQueue queue) {
            super(obj, queue);
            this._recid = recid;
        }
    }

    static final class SoftCacheEntry
    extends SoftReference
    implements ReferenceCacheEntry {
        protected final long _recid;

        public long getRecid() {
            return this._recid;
        }

        SoftCacheEntry(long recid, Object obj, ReferenceQueue queue) {
            super(obj, queue);
            this._recid = recid;
        }
    }

    static interface ReferenceCacheEntry {
        public long getRecid();

        public void clear();

        public Object get();
    }

    static final class CacheEntry {
        protected long _recid;
        protected Object _obj;
        protected Serializer _serializer;
        protected boolean _isDirty;
        protected CacheEntry _previous;
        protected CacheEntry _next;

        CacheEntry(long recid, Object obj, Serializer serializer, boolean isDirty) {
            this._recid = recid;
            this._obj = obj;
            this._serializer = serializer;
            this._isDirty = isDirty;
        }
    }
}

