/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOException;
import net.kotek.jdbm.BlockIo;
import net.kotek.jdbm.PageManager;
import net.kotek.jdbm.RecordFile;
import net.kotek.jdbm.Utils;

final class FreeLogicalRowIdPageManager {
    private RecordFile file;
    private PageManager pageman;
    private final Utils.LongArrayList freeBlocksInTransactionRowid = new Utils.LongArrayList();

    FreeLogicalRowIdPageManager(RecordFile file, PageManager pageman) throws IOException {
        this.file = file;
        this.pageman = pageman;
    }

    long get() throws IOException {
        if (this.freeBlocksInTransactionRowid.size != 0) {
            long first = this.freeBlocksInTransactionRowid.data[this.freeBlocksInTransactionRowid.size - 1];
            this.freeBlocksInTransactionRowid.removeLast();
            return first;
        }
        long retval = 0L;
        long current = this.pageman.getFirst((short)3);
        while (current != 0L) {
            BlockIo fp = this.file.get(current);
            short slot = fp.FreeLogicalRowId_getFirstAllocated();
            if (slot != -1) {
                retval = fp.FreeLogicalRowId_slotToLocation(slot);
                fp.FreeLogicalRowId_free(slot);
                if (fp.FreeLogicalRowId_getCount() == 0) {
                    this.file.release(current, false);
                    this.pageman.free((short)3, current);
                } else {
                    this.file.release(current, true);
                }
                return retval;
            }
            this.file.release(current, false);
            current = this.pageman.getNext(current);
        }
        return 0L;
    }

    void put(long rowid) throws IOException {
        this.freeBlocksInTransactionRowid.add(rowid);
    }

    public void commit() throws IOException {
        short freePhysRowId;
        long rowid;
        short slot;
        BlockIo fp;
        int rowIdPos = 0;
        long current = this.pageman.getFirst((short)3);
        while (current != 0L) {
            fp = this.file.get(current);
            slot = fp.FreeLogicalRowId_getFirstFree();
            while (slot != -1 && rowIdPos < this.freeBlocksInTransactionRowid.size) {
                rowid = this.freeBlocksInTransactionRowid.data[rowIdPos++];
                freePhysRowId = fp.FreeLogicalRowId_alloc(slot);
                fp.pageHeaderSetLocation(freePhysRowId, rowid);
                slot = fp.FreeLogicalRowId_getFirstFree();
            }
            this.file.release(current, true);
            if (rowIdPos >= this.freeBlocksInTransactionRowid.size) break;
            current = this.pageman.getNext(current);
        }
        while (rowIdPos < this.freeBlocksInTransactionRowid.size) {
            long freePage = this.pageman.allocate((short)3);
            fp = this.file.get(freePage);
            slot = fp.FreeLogicalRowId_getFirstFree();
            while (slot != -1 && rowIdPos < this.freeBlocksInTransactionRowid.size) {
                rowid = this.freeBlocksInTransactionRowid.data[rowIdPos++];
                freePhysRowId = fp.FreeLogicalRowId_alloc(slot);
                fp.pageHeaderSetLocation(freePhysRowId, rowid);
                slot = fp.FreeLogicalRowId_getFirstFree();
            }
            this.file.release(freePage, true);
            if (rowIdPos < this.freeBlocksInTransactionRowid.size) continue;
            break;
        }
        if (rowIdPos < this.freeBlocksInTransactionRowid.size) {
            throw new InternalError();
        }
        this.freeBlocksInTransactionRowid.clear();
    }

    public void rollback() {
        this.freeBlocksInTransactionRowid.clear();
    }
}

