/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOException;
import net.kotek.jdbm.BlockIo;
import net.kotek.jdbm.PageManager;
import net.kotek.jdbm.RecordFile;
import net.kotek.jdbm.Utils;

final class FreePhysicalRowIdPageManager {
    static final transient int wasteMargin = 128;
    static final transient int wasteMargin2 = 3;
    protected RecordFile _file;
    protected PageManager _pageman;
    private final Utils.LongArrayList freeBlocksInTransactionRowid = new Utils.LongArrayList();
    private final Utils.IntArrayList freeBlocksInTransactionSize = new Utils.IntArrayList();
    private int lastMaxSize = -1;

    FreePhysicalRowIdPageManager(RecordFile file, PageManager pageman) throws IOException {
        this._file = file;
        this._pageman = pageman;
    }

    long get(int size) throws IOException {
        if (this.lastMaxSize != -1 && size > this.lastMaxSize) {
            return 0L;
        }
        long retval = 0L;
        int maxSize = -1;
        long current = this._pageman.getFirst((short)4);
        while (current != 0L) {
            BlockIo fp = this._file.get(current);
            int slot = fp.FreePhysicalRowId_getFirstLargerThan(size);
            if (slot > 0) {
                this.lastMaxSize = -1;
                retval = fp.FreePhysicalRowId_slotToLocation(slot);
                fp.FreePhysicalRowId_free(slot);
                if (fp.FreePhysicalRowId_getCount() == 0) {
                    this._file.release(current, false);
                    this._pageman.free((short)4, current);
                } else {
                    this._file.release(current, true);
                }
                return retval;
            }
            if (maxSize < -slot) {
                maxSize = -slot;
            }
            this._file.release(current, false);
            current = this._pageman.getNext(current);
        }
        this.lastMaxSize = maxSize;
        return 0L;
    }

    void put(long rowid, int size) throws IOException {
        this.freeBlocksInTransactionRowid.add(rowid);
        this.freeBlocksInTransactionSize.add(size);
    }

    public void commit() throws IOException {
        int rowidpos = 0;
        if (this.freeBlocksInTransactionRowid.size < 200) {
            long current;
            boolean fromLast = Math.random() < 0.5;
            long l = current = fromLast ? this._pageman.getLast((short)4) : this._pageman.getFirst((short)4);
            while (current != 0L) {
                BlockIo fp = this._file.get(current);
                int slot = fp.FreePhysicalRowId_getFirstFree();
                while (slot != -1 && rowidpos < this.freeBlocksInTransactionRowid.size) {
                    int size = this.freeBlocksInTransactionSize.data[rowidpos];
                    long rowid = this.freeBlocksInTransactionRowid.data[rowidpos++];
                    short freePhysRowId = fp.FreePhysicalRowId_alloc(slot);
                    fp.pageHeaderSetLocation(freePhysRowId, rowid);
                    fp.FreePhysicalRowId_setSize(freePhysRowId, size);
                    slot = fp.FreePhysicalRowId_getFirstFree();
                }
                this._file.release(current, true);
                if (rowidpos >= this.freeBlocksInTransactionRowid.size) break;
                current = fromLast ? this._pageman.getPrev(current) : this._pageman.getNext(current);
            }
        }
        while (rowidpos < this.freeBlocksInTransactionRowid.size) {
            long freePage = this._pageman.allocate((short)4);
            BlockIo fp = this._file.get(freePage);
            int slot = fp.FreePhysicalRowId_getFirstFree();
            while (slot != -1 && rowidpos < this.freeBlocksInTransactionRowid.size) {
                int size = this.freeBlocksInTransactionSize.data[rowidpos];
                long rowid = this.freeBlocksInTransactionRowid.data[rowidpos++];
                short freePhysRowId = fp.FreePhysicalRowId_alloc(slot);
                fp.pageHeaderSetLocation(freePhysRowId, rowid);
                fp.FreePhysicalRowId_setSize(freePhysRowId, size);
                slot = fp.FreePhysicalRowId_getFirstFree();
            }
            this._file.release(freePage, true);
            if (rowidpos < this.freeBlocksInTransactionRowid.size) continue;
            break;
        }
        if (rowidpos < this.freeBlocksInTransactionRowid.size) {
            throw new InternalError();
        }
        this.freeBlocksInTransactionRowid.clear();
        this.freeBlocksInTransactionSize.clear();
    }

    public void rollback() {
        this.freeBlocksInTransactionRowid.clear();
        this.freeBlocksInTransactionSize.clear();
    }
}

