/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import net.kotek.jdbm.BTreeLazyRecord;
import net.kotek.jdbm.DataInputOutput;
import net.kotek.jdbm.HTree;
import net.kotek.jdbm.LongPacker;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HTreeBucket<K, V> {
    public static final int OVERFLOW_SIZE = 8;
    private byte _depth;
    private Object[] _keysAndValues;
    private byte size = 0;
    private final HTree<K, V> tree;

    public HTreeBucket(HTree<K, V> tree) {
        this.tree = tree;
    }

    public HTreeBucket(HTree<K, V> tree, byte level) {
        this.tree = tree;
        if (level > 4) {
            throw new IllegalArgumentException("Cannot create bucket with depth > MAX_DEPTH+1. Depth=" + level);
        }
        this._depth = level;
        this._keysAndValues = new Object[16];
    }

    public int getElementCount() {
        return this.size;
    }

    public boolean isLeaf() {
        return this._depth > 3;
    }

    public boolean hasRoom() {
        if (this.isLeaf()) {
            return true;
        }
        return this.size < 8;
    }

    public V addElement(K key, V value) {
        int existing = -1;
        for (byte i = 0; i < this.size; i = (byte)(i + 1)) {
            if (!key.equals(this._keysAndValues[i])) continue;
            existing = i;
            break;
        }
        if (existing != -1) {
            Object before = this._keysAndValues[existing + 8];
            if (before instanceof BTreeLazyRecord) {
                BTreeLazyRecord rec = (BTreeLazyRecord)before;
                before = rec.get();
                rec.delete();
            }
            this._keysAndValues[existing + 8] = value;
            return (V)before;
        }
        this._keysAndValues[this.size] = key;
        this._keysAndValues[this.size + 8] = value;
        this.size = (byte)(this.size + 1);
        return null;
    }

    public V removeElement(K key) {
        int existing = -1;
        for (byte i = 0; i < this.size; i = (byte)(i + 1)) {
            if (!key.equals(this._keysAndValues[i])) continue;
            existing = i;
            break;
        }
        if (existing != -1) {
            Object o = this._keysAndValues[existing + 8];
            if (o instanceof BTreeLazyRecord) {
                BTreeLazyRecord rec = (BTreeLazyRecord)o;
                o = rec.get();
                rec.delete();
            }
            this.size = (byte)(this.size - 1);
            this._keysAndValues[existing] = this._keysAndValues[this.size];
            this._keysAndValues[existing + 8] = this._keysAndValues[this.size + 8];
            this._keysAndValues[this.size] = null;
            this._keysAndValues[this.size + 8] = null;
            return (V)o;
        }
        return null;
    }

    public V getValue(K key) {
        int existing = -1;
        for (byte i = 0; i < this.size; i = (byte)(i + 1)) {
            if (!key.equals(this._keysAndValues[i])) continue;
            existing = i;
            break;
        }
        if (existing != -1) {
            Object o = this._keysAndValues[existing + 8];
            if (o instanceof BTreeLazyRecord) {
                return (V)((BTreeLazyRecord)o).get();
            }
            return (V)o;
        }
        return null;
    }

    ArrayList<K> getKeys() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (byte i = 0; i < this.size; i = (byte)(i + 1)) {
            ret.add(this._keysAndValues[i]);
        }
        return ret;
    }

    ArrayList<V> getValues() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (byte i = 0; i < this.size; i = (byte)(i + 1)) {
            ret.add(this._keysAndValues[i + 8]);
        }
        return ret;
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.write(this._depth);
        out.write(this.size);
        DataInputOutput out3 = this.tree.writeBufferCache.getAndSet(null);
        if (out3 == null) {
            out3 = new DataInputOutput();
        } else {
            out3.reset();
        }
        Serializer keySerializer = this.tree.keySerializer != null ? this.tree.keySerializer : this.tree.getRecordManager().defaultSerializer();
        for (byte i = 0; i < this.size; i = (byte)(i + 1)) {
            out3.reset();
            keySerializer.serialize(out3, this._keysAndValues[i]);
            LongPacker.packInt(out, out3.getPos());
            out.write(out3.getBuf(), 0, out3.getPos());
        }
        if (this.tree.hasValues()) {
            Serializer valSerializer = this.tree.valueSerializer != null ? this.tree.valueSerializer : this.tree.getRecordManager().defaultSerializer();
            for (byte i = 0; i < this.size; i = (byte)(i + 1)) {
                Object value = this._keysAndValues[i + 8];
                if (value == null) {
                    out.write(255);
                    continue;
                }
                if (value instanceof BTreeLazyRecord) {
                    out.write(254);
                    LongPacker.packLong(out, ((BTreeLazyRecord)value).recid);
                    continue;
                }
                out3.reset();
                valSerializer.serialize(out3, value);
                if (out3.getPos() > 32) {
                    long recid = this.tree.getRecordManager().insert(out3.toByteArray(), BTreeLazyRecord.FAKE_SERIALIZER, true);
                    out.write(254);
                    LongPacker.packLong(out, recid);
                    continue;
                }
                out.write(out3.getPos());
                out.write(out3.getBuf(), 0, out3.getPos());
            }
        }
        this.tree.writeBufferCache.set(out3);
    }

    public void readExternal(DataInputOutput in) throws IOException, ClassNotFoundException {
        byte i;
        this._depth = in.readByte();
        this.size = in.readByte();
        Serializer keySerializer = this.tree.keySerializer != null ? this.tree.keySerializer : this.tree.getRecordManager().defaultSerializer();
        this._keysAndValues = new Object[16];
        for (i = 0; i < this.size; i = (byte)(i + 1)) {
            Object key;
            int expectedSize = LongPacker.unpackInt(in);
            this._keysAndValues[i] = key = BTreeLazyRecord.fastDeser(in, keySerializer, expectedSize);
        }
        if (this.tree.hasValues()) {
            Serializer valSerializer = this.tree.valueSerializer != null ? this.tree.valueSerializer : this.tree.getRecordManager().defaultSerializer();
            for (byte i2 = 0; i2 < this.size; i2 = (byte)(i2 + 1)) {
                int header = in.readUnsignedByte();
                if (header == 255) {
                    this._keysAndValues[i2 + 8] = null;
                    continue;
                }
                if (header == 254) {
                    long recid = LongPacker.unpackLong(in);
                    this._keysAndValues[i2 + 8] = new BTreeLazyRecord(this.tree.getRecordManager(), recid, valSerializer);
                    continue;
                }
                this._keysAndValues[i2 + 8] = BTreeLazyRecord.fastDeser(in, valSerializer, header);
            }
        } else {
            for (i = 0; i < this.size; i = (byte)(i + 1)) {
                if (this._keysAndValues[i] == null) continue;
                this._keysAndValues[i + 8] = "";
            }
        }
    }
}

