/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.DBStore;
import net.kotek.jdbm.DataInputOutput;
import net.kotek.jdbm.LongPacker;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinkedList<E>
extends AbstractSequentialList<E> {
    private DBAbstract db;
    private long rootRecid;
    private static final Serializer<Root> ROOT_SERIALIZER = new Serializer<Root>(){

        @Override
        public void serialize(DataOutput out, Root obj) throws IOException {
            LongPacker.packLong(out, obj.first);
            LongPacker.packLong(out, obj.last);
            LongPacker.packLong(out, obj.size);
        }

        @Override
        public Root deserialize(DataInput in) throws IOException, ClassNotFoundException {
            Root r = new Root();
            r.first = LongPacker.unpackLong(in);
            r.last = LongPacker.unpackLong(in);
            r.size = LongPacker.unpackLong(in);
            return r;
        }
    };
    private Serializer<E> valueSerializer;
    protected boolean loadValues = true;
    private final Serializer<Entry> entrySerializer = new Serializer<Entry>(){

        @Override
        public void serialize(DataOutput out, Entry e) throws IOException {
            LongPacker.packLong(out, e.prev);
            LongPacker.packLong(out, e.next);
            if (LinkedList.this.valueSerializer != null) {
                LinkedList.this.valueSerializer.serialize(out, e.value);
            } else {
                LinkedList.this.db.defaultSerializer().serialize(out, e.value);
            }
        }

        @Override
        public Entry<E> deserialize(DataInput in) throws IOException, ClassNotFoundException {
            long prev = LongPacker.unpackLong(in);
            long next = LongPacker.unpackLong(in);
            Object value = null;
            if (LinkedList.this.loadValues) {
                value = LinkedList.this.valueSerializer == null ? LinkedList.this.db.defaultSerializer().deserialize(in) : LinkedList.this.valueSerializer.deserialize(in);
            }
            return new Entry<Object>(prev, next, value);
        }
    };

    LinkedList(long rootRecid, Serializer<E> valueSerializer) {
        this.rootRecid = rootRecid;
        this.valueSerializer = valueSerializer;
    }

    LinkedList(DBAbstract db, Serializer<E> valueSerializer) throws IOException {
        this.db = db;
        if (valueSerializer != null && !(valueSerializer instanceof Serializable)) {
            throw new IllegalArgumentException("Serializer does not implement Serializable");
        }
        this.valueSerializer = valueSerializer;
        this.rootRecid = db.insert(new Root(), ROOT_SERIALIZER, false);
    }

    void setPersistenceContext(DBAbstract db) {
        this.db = db;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Root r = this.getRoot();
        if (index < 0 || (long)index > r.size) {
            throw new IndexOutOfBoundsException();
        }
        Iter iter = new Iter();
        iter.next = r.first;
        for (int i = 0; i < index; ++i) {
            iter.next();
        }
        return iter;
    }

    private Root getRoot() {
        try {
            return this.db.fetch(this.rootRecid, ROOT_SERIALIZER);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public int size() {
        return (int)this.getRoot().size;
    }

    @Override
    public boolean add(Object value) {
        try {
            Root r = this.getRoot();
            Entry<Object> e = new Entry<Object>(r.last, 0L, value);
            long recid = this.db.insert(e, this.entrySerializer, false);
            if (r.last != 0L) {
                Entry oldLast = this.db.fetch(r.last, this.entrySerializer);
                if (oldLast.next != 0L) {
                    throw new Error();
                }
                oldLast.next = recid;
                this.db.update(r.last, oldLast, this.entrySerializer);
            }
            r.last = recid;
            if (r.first == 0L) {
                r.first = recid;
            }
            ++r.size;
            this.db.update(this.rootRecid, r, ROOT_SERIALIZER);
            ++this.modCount;
            return true;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private Entry<E> fetch(long recid) {
        try {
            return this.db.fetch(recid, this.entrySerializer);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    static LinkedList deserialize(DataInput is, Serializer ser) throws IOException, ClassNotFoundException {
        long rootrecid = LongPacker.unpackLong(is);
        Serializer serializer = (Serializer)ser.deserialize(is);
        return new LinkedList(rootrecid, serializer);
    }

    void serialize(DataOutput out) throws IOException {
        LongPacker.packLong(out, this.rootRecid);
        this.db.defaultSerializer().serialize(out, this.valueSerializer);
    }

    static void defrag(long recid, DBStore r1, DBStore r2) throws IOException {
        try {
            byte[] data = r1.fetchRaw(recid);
            r2.forceInsert(recid, data);
            DataInputOutput in = new DataInputOutput();
            in.reset(data);
            LinkedList l = (LinkedList)r1.defaultSerializer().deserialize(in);
            l.loadValues = false;
            if (l.rootRecid == 0L) {
                return;
            }
            data = r1.fetchRaw(l.rootRecid);
            r2.forceInsert(l.rootRecid, data);
            in.reset(data);
            Root r = ROOT_SERIALIZER.deserialize(in);
            long current = r.first;
            while (current != 0L) {
                data = r1.fetchRaw(current);
                in.reset(data);
                r2.forceInsert(current, data);
                Entry e = l.entrySerializer.deserialize(in);
                current = e.next;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOError(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Iter
    implements ListIterator<E> {
        private int expectedModCount;
        private int index;
        private long prev;
        private long next;
        private byte lastOper;

        private Iter() {
            this.expectedModCount = LinkedList.this.modCount;
            this.index = 0;
            this.prev = 0L;
            this.next = 0L;
            this.lastOper = 0;
        }

        @Override
        public boolean hasNext() {
            return this.next != 0L;
        }

        @Override
        public E next() {
            if (this.next == 0L) {
                throw new NoSuchElementException();
            }
            this.checkForComodification();
            Entry e = LinkedList.this.fetch(this.next);
            this.prev = this.next;
            this.next = e.next;
            ++this.index;
            this.lastOper = 1;
            return e.value;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != 0L;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            Entry e = LinkedList.this.fetch(this.prev);
            this.next = this.prev;
            this.prev = e.prev;
            --this.index;
            this.lastOper = (byte)-1;
            return e.value;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            block12: {
                this.checkForComodification();
                try {
                    if (this.lastOper == 1) {
                        this.lastOper = 0;
                        Entry p = (Entry)LinkedList.this.db.fetch(this.prev, LinkedList.this.entrySerializer);
                        if (p.prev != 0L) {
                            Entry pp = (Entry)LinkedList.this.db.fetch(p.prev, LinkedList.this.entrySerializer);
                            pp.next = p.next;
                            LinkedList.this.db.update(p.prev, pp, LinkedList.this.entrySerializer);
                        }
                        if (p.next != 0L) {
                            Entry pn = (Entry)LinkedList.this.db.fetch(p.next, LinkedList.this.entrySerializer);
                            pn.prev = p.prev;
                            LinkedList.this.db.update(p.next, pn, LinkedList.this.entrySerializer);
                        }
                        LinkedList.this.db.delete(this.prev);
                        Root r = LinkedList.this.getRoot();
                        if (r.first == this.prev) {
                            r.first = this.next;
                        }
                        if (r.last == this.prev) {
                            r.last = this.next;
                        }
                        --r.size;
                        LinkedList.this.db.update(LinkedList.this.rootRecid, r, ROOT_SERIALIZER);
                        LinkedList.this.modCount++;
                        ++this.expectedModCount;
                        this.prev = p.prev;
                        break block12;
                    }
                    if (this.lastOper == -1) {
                        this.lastOper = 0;
                        Entry n = (Entry)LinkedList.this.db.fetch(this.next, LinkedList.this.entrySerializer);
                        if (n.prev != 0L) {
                            Entry pp = (Entry)LinkedList.this.db.fetch(n.prev, LinkedList.this.entrySerializer);
                            pp.next = n.next;
                            LinkedList.this.db.update(n.prev, pp, LinkedList.this.entrySerializer);
                        }
                        if (n.next != 0L) {
                            Entry pn = (Entry)LinkedList.this.db.fetch(n.next, LinkedList.this.entrySerializer);
                            pn.prev = n.prev;
                            LinkedList.this.db.update(n.next, pn, LinkedList.this.entrySerializer);
                        }
                        LinkedList.this.db.delete(this.next);
                        Root r = LinkedList.this.getRoot();
                        if (r.last == this.next) {
                            r.last = this.prev;
                        }
                        if (r.first == this.next) {
                            r.first = this.prev;
                        }
                        --r.size;
                        LinkedList.this.db.update(LinkedList.this.rootRecid, r, ROOT_SERIALIZER);
                        LinkedList.this.modCount++;
                        ++this.expectedModCount;
                        this.next = n.next;
                        break block12;
                    }
                    throw new IllegalStateException();
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }

        @Override
        public void set(E value) {
            block4: {
                this.checkForComodification();
                try {
                    if (this.lastOper == 1) {
                        this.lastOper = 0;
                        Entry n = (Entry)LinkedList.this.db.fetch(this.prev, LinkedList.this.entrySerializer);
                        n.value = value;
                        LinkedList.this.db.update(this.prev, n, LinkedList.this.entrySerializer);
                        break block4;
                    }
                    if (this.lastOper == -1) {
                        this.lastOper = 0;
                        Entry n = (Entry)LinkedList.this.db.fetch(this.next, LinkedList.this.entrySerializer);
                        n.value = value;
                        LinkedList.this.db.update(this.next, n, LinkedList.this.entrySerializer);
                        break block4;
                    }
                    throw new IllegalStateException();
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }

        @Override
        public void add(E value) {
            this.checkForComodification();
            if (this.next == 0L) {
                LinkedList.this.add(value);
                ++this.expectedModCount;
                return;
            }
            try {
                Entry e = new Entry(this.prev, this.next, value);
                long recid = LinkedList.this.db.insert(e, LinkedList.this.entrySerializer, false);
                if (this.prev != 0L) {
                    Entry p = (Entry)LinkedList.this.db.fetch(this.prev, LinkedList.this.entrySerializer);
                    if (p.next != this.next) {
                        throw new Error();
                    }
                    p.next = recid;
                    LinkedList.this.db.update(this.prev, p, LinkedList.this.entrySerializer);
                }
                Entry n = LinkedList.this.fetch(this.next);
                if (n.prev != this.prev) {
                    throw new Error();
                }
                n.prev = recid;
                LinkedList.this.db.update(this.next, n, LinkedList.this.entrySerializer);
                Root r = LinkedList.this.getRoot();
                ++r.size;
                LinkedList.this.db.update(LinkedList.this.rootRecid, r, ROOT_SERIALIZER);
                ++this.expectedModCount;
                LinkedList.this.modCount++;
                this.prev = recid;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<E> {
        long prev = 0L;
        long next = 0L;
        E value;

        public Entry(long prev, long next, E value) {
            this.prev = prev;
            this.next = next;
            this.value = value;
        }
    }

    private static final class Root {
        long first;
        long last;
        long size;

        private Root() {
        }
    }
}

