/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOException;
import net.kotek.jdbm.BlockIo;
import net.kotek.jdbm.DataInputOutput;
import net.kotek.jdbm.FreePhysicalRowIdPageManager;
import net.kotek.jdbm.Location;
import net.kotek.jdbm.PageManager;
import net.kotek.jdbm.RecordFile;
import net.kotek.jdbm.RecordHeader;

final class PhysicalRowIdManager {
    private final RecordFile file;
    private final PageManager pageman;
    private final FreePhysicalRowIdPageManager freeman;
    private static final short DATA_PER_PAGE = 4080;
    private long cachedLastAllocatedRecordPage = Long.MIN_VALUE;
    private short cachedLastAllocatedRecordOffset = Short.MIN_VALUE;

    PhysicalRowIdManager(RecordFile file, PageManager pageManager, FreePhysicalRowIdPageManager freeman) throws IOException {
        this.file = file;
        this.pageman = pageManager;
        this.freeman = freeman;
    }

    long insert(byte[] data, int start, int length) throws IOException {
        if (length < 1) {
            throw new IllegalArgumentException("Length is <1");
        }
        if (start < 0) {
            throw new IllegalArgumentException("negative start");
        }
        long retval = this.alloc(length);
        this.write(retval, data, start, length);
        return retval;
    }

    long update(long rowid, byte[] data, int start, int length) throws IOException {
        short head;
        BlockIo block = this.file.get(Location.getBlock(rowid));
        int availSize = RecordHeader.getAvailableSize(block, head = Location.getOffset(rowid));
        if (length > availSize || availSize - length > 254) {
            this.file.release(block);
            this.free(rowid);
            rowid = this.alloc(length);
        } else {
            this.file.release(block);
        }
        this.write(rowid, data, start, length);
        return rowid;
    }

    void fetch(DataInputOutput out, long rowid) throws IOException {
        short head;
        long current = Location.getBlock(rowid);
        BlockIo block = this.file.get(current);
        int size = RecordHeader.getCurrentSize(block, head = Location.getOffset(rowid));
        if (size == 0) {
            this.file.release(current, false);
            return;
        }
        int leftToRead = size;
        int dataOffset = Location.getOffset(rowid) + 3;
        while (leftToRead > 0) {
            int toCopy = 4096 - dataOffset;
            if (leftToRead < toCopy) {
                toCopy = leftToRead;
            }
            out.writeFromByteBuffer(block.getData(), dataOffset, toCopy);
            this.file.release(block);
            if ((leftToRead -= toCopy) <= 0) continue;
            current = this.pageman.getNext(current);
            block = this.file.get(current);
            dataOffset = 16;
        }
    }

    private long alloc(int size) throws IOException {
        long retval = this.freeman.get(size = RecordHeader.roundAvailableSize(size));
        if (retval == 0L) {
            retval = this.allocNew(size, this.pageman.getLast((short)1));
        }
        return retval;
    }

    private long allocNew(int size, long start) throws IOException {
        BlockIo curPage;
        if (start == 0L || this.cachedLastAllocatedRecordPage == start && this.cachedLastAllocatedRecordOffset == 4096) {
            start = this.pageman.allocate((short)1);
            curPage = this.file.get(start);
            curPage.dataPageSetFirst((short)16);
            this.cachedLastAllocatedRecordOffset = (short)16;
            this.cachedLastAllocatedRecordPage = curPage.getBlockId();
            RecordHeader.setAvailableSize(curPage, (short)16, 0);
            RecordHeader.setCurrentSize(curPage, (short)16, 0);
        } else {
            curPage = this.file.get(start);
        }
        short pos = curPage.dataPageGetFirst();
        if (pos == 0) {
            this.file.release(curPage);
            return this.allocNew(size, 0L);
        }
        short hdr = pos;
        if (this.cachedLastAllocatedRecordPage != curPage.getBlockId()) {
            int availSize = RecordHeader.getAvailableSize(curPage, hdr);
            while (availSize != 0 && pos < 4096) {
                if ((pos = (short)(pos + (availSize + 3))) == 4096) {
                    this.file.release(curPage);
                    return this.allocNew(size, 0L);
                }
                hdr = pos;
                availSize = RecordHeader.getAvailableSize(curPage, hdr);
            }
        } else {
            hdr = this.cachedLastAllocatedRecordOffset;
            pos = this.cachedLastAllocatedRecordOffset;
        }
        if (pos == 3) {
            this.file.release(curPage);
        }
        if (hdr > 4080) {
            this.file.release(curPage);
            return this.allocNew(size, 0L);
        }
        long retval = Location.toLong(start, pos);
        int freeHere = 4096 - pos - 3;
        if (freeHere < size) {
            int neededLeft;
            int lastSize = (size - freeHere) % 4080;
            if (size < 4080 && 4080 - lastSize < 19) {
                size += 4080 - lastSize;
                size = RecordHeader.roundAvailableSize(size);
            }
            RecordHeader.setAvailableSize(curPage, hdr, size);
            this.file.release(start, true);
            for (neededLeft = size - freeHere; neededLeft >= 4080; neededLeft -= 4080) {
                start = this.pageman.allocate((short)1);
                curPage = this.file.get(start);
                curPage.dataPageSetFirst((short)0);
                this.file.release(start, true);
            }
            if (neededLeft > 0) {
                start = this.pageman.allocate((short)1);
                curPage = this.file.get(start);
                curPage.dataPageSetFirst((short)(16 + neededLeft));
                this.file.release(start, true);
                this.cachedLastAllocatedRecordOffset = (short)(16 + neededLeft);
                this.cachedLastAllocatedRecordPage = curPage.getBlockId();
            }
        } else {
            if (freeHere - size <= 19) {
                size = freeHere;
            }
            RecordHeader.setAvailableSize(curPage, hdr, size);
            this.file.release(start, true);
            this.cachedLastAllocatedRecordOffset = (short)(hdr + 3 + size);
            this.cachedLastAllocatedRecordPage = curPage.getBlockId();
        }
        return retval;
    }

    void free(long id) throws IOException {
        short offset;
        BlockIo curBlock = this.file.get(Location.getBlock(id));
        int size = RecordHeader.getAvailableSize(curBlock, offset = Location.getOffset(id));
        if (size > 4080) {
            // empty if block
        }
        RecordHeader.setCurrentSize(curBlock, offset, 0);
        this.file.release(Location.getBlock(id), true);
        this.freeman.put(id, size);
    }

    private void write(long rowid, byte[] data, int start, int length) throws IOException {
        long current = Location.getBlock(rowid);
        BlockIo block = this.file.get(current);
        short hdr = Location.getOffset(rowid);
        RecordHeader.setCurrentSize(block, hdr, length);
        if (length == 0) {
            this.file.release(current, true);
            return;
        }
        int offsetInBuffer = start;
        int leftToWrite = length;
        int dataOffset = Location.getOffset(rowid) + 3;
        while (leftToWrite > 0) {
            int toCopy = 4096 - dataOffset;
            if (leftToWrite < toCopy) {
                toCopy = leftToWrite;
            }
            block.writeByteArray(data, offsetInBuffer, dataOffset, toCopy);
            offsetInBuffer += toCopy;
            this.file.release(current, true);
            if ((leftToWrite -= toCopy) <= 0) continue;
            current = this.pageman.getNext(current);
            block = this.file.get(current);
            dataOffset = 16;
        }
    }

    void rollback() throws IOException {
        this.cachedLastAllocatedRecordPage = Long.MIN_VALUE;
        this.cachedLastAllocatedRecordOffset = Short.MIN_VALUE;
        this.freeman.rollback();
    }

    void commit() throws IOException {
        this.freeman.commit();
    }
}

