/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import net.kotek.jdbm.BlockIo;

final class RecordHeader {
    private static final short O_CURRENTSIZE = 0;
    private static final short O_AVAILABLESIZE = 1;
    static final int MAX_RECORD_SIZE = 0x7F7FFF;
    static final int SIZE = 3;
    static final int MAX_SIZE_SPACE = 254;

    RecordHeader() {
    }

    static int getCurrentSize(BlockIo block, short pos) {
        int s = block.readByte(pos + 0) & 0xFF;
        if (s == 255) {
            return 0;
        }
        return RecordHeader.getAvailableSize(block, pos) - s;
    }

    static void setCurrentSize(BlockIo block, short pos, int value) {
        if (value == 0) {
            block.writeByte(pos + 0, (byte)-1);
            return;
        }
        int availSize = RecordHeader.getAvailableSize(block, pos);
        if (value < availSize - 254 || value > availSize) {
            throw new IllegalArgumentException("currentSize out of bounds, need to realocate " + value + " - " + availSize);
        }
        block.writeByte(pos + 0, (byte)(availSize - value));
    }

    static int getAvailableSize(BlockIo block, short pos) {
        return RecordHeader.deconvertAvailSize(block.readShort(pos + 1));
    }

    static void setAvailableSize(BlockIo block, short pos, int value) {
        if (value != RecordHeader.roundAvailableSize(value)) {
            throw new IllegalArgumentException("value is not rounded");
        }
        int oldCurrSize = RecordHeader.getCurrentSize(block, pos);
        block.writeShort(pos + 1, RecordHeader.convertAvailSize(value));
        RecordHeader.setCurrentSize(block, pos, oldCurrSize);
    }

    static short convertAvailSize(int recordSize) {
        if (recordSize <= Short.MAX_VALUE) {
            return (short)recordSize;
        }
        int shift = recordSize - Short.MAX_VALUE;
        shift = shift % 254 == 0 ? (shift /= 254) : 1 + shift / 254;
        shift = -shift;
        return (short)shift;
    }

    static int deconvertAvailSize(short converted) {
        if (converted >= 0) {
            return converted;
        }
        int shifted = -converted;
        return Short.MAX_VALUE + (shifted *= 254);
    }

    static int roundAvailableSize(int value) {
        if (value > 0x7F7FFF) {
            new InternalError("Maximal record size (8355839) exceeded: " + value);
        }
        return RecordHeader.deconvertAvailSize(RecordHeader.convertAvailSize(value));
    }
}

