/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOError;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import javax.crypto.Cipher;

class Utils {
    static final String EMPTY_STRING = "";
    static final Comparator COMPARABLE_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };

    Utils() {
    }

    public static byte[] encrypt(Cipher cipherIn, ByteBuffer b) {
        if (cipherIn == null && b.hasArray()) {
            return b.array();
        }
        byte[] bb = new byte[4096];
        b.rewind();
        b.get(bb, 0, 4096);
        return Utils.encrypt(cipherIn, bb);
    }

    public static byte[] encrypt(Cipher cipherIn, byte[] b) {
        if (cipherIn == null) {
            return b;
        }
        try {
            return cipherIn.doFinal(b);
        }
        catch (Exception e) {
            throw new IOError(e);
        }
    }

    static String formatSpaceUsage(long size) {
        if ((double)size < 10000.0) {
            return size + "B";
        }
        if ((double)size < 1.0E7) {
            return EMPTY_STRING + Math.round(1.0 * (double)size / 1024.0) + "KB";
        }
        if ((double)size < 1.0E10) {
            return EMPTY_STRING + Math.round(1.0 * (double)size / 1000000.0) + "MB";
        }
        return EMPTY_STRING + Math.round(1.0 * (double)size / 1.0E9) + "GB";
    }

    static boolean allZeros(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == 0) continue;
            return false;
        }
        return true;
    }

    static final class IntArrayList {
        int size = 0;
        int[] data = new int[32];

        IntArrayList() {
        }

        void add(int l) {
            if (this.data.length == this.size) {
                this.data = Arrays.copyOf(this.data, this.size * 2);
            }
            this.data[this.size] = l;
            ++this.size;
        }

        void removeLast() {
            --this.size;
            this.data[this.size] = 0;
        }

        public void clear() {
            if (this.data.length > 128) {
                this.data = new int[32];
            } else {
                for (int i = 0; i < this.size; ++i) {
                    this.data[i] = 0;
                }
            }
            this.size = 0;
        }
    }

    static final class LongArrayList {
        int size = 0;
        long[] data = new long[16];

        LongArrayList() {
        }

        void add(long l) {
            if (this.data.length == this.size) {
                this.data = Arrays.copyOf(this.data, this.size * 2);
            }
            this.data[this.size] = l;
            ++this.size;
        }

        void removeLast() {
            --this.size;
            this.data[this.size] = 0L;
        }

        public void clear() {
            if (this.data.length > 128) {
                this.data = new long[16];
            } else {
                for (int i = 0; i < this.size; ++i) {
                    this.data[i] = 0L;
                }
            }
            this.size = 0;
        }
    }
}

