/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.equals.DefaultEquator;
import org.conqat.lib.commons.equals.IEquator;
import org.conqat.lib.commons.string.StringUtils;

public class Diff<T> {
    private final List<T> a;
    private final List<T> b;
    private final IEquator<T> equator;
    private final int n;
    private final int m;
    private final int max;
    private final int[][] v;
    private final boolean[][] from;

    private Diff(List<T> a, List<T> b, IEquator<T> equator) {
        this.a = a;
        this.b = b;
        this.equator = equator;
        this.n = a.size();
        this.m = b.size();
        this.max = this.n + this.m;
        this.v = new int[this.max + 1][];
        this.from = new boolean[this.max + 1][];
    }

    private Delta<T> computeDelta() {
        return this.constructDelta(this.calculateDeltaSize());
    }

    private Delta<T> constructDelta(int size) {
        int d = size;
        int k = -size;
        while (this.v[size][size + k] < this.n || this.v[size][d + k] - k < this.m) {
            ++k;
        }
        Delta delta = new Delta(size, this.n, this.m);
        int difference = this.n - this.m;
        while (d > 0) {
            k = this.from[d][d + k] ? ++k : --k;
            int x = this.v[d][--d + k];
            int y = x - k;
            int newDifference = x - y;
            if (newDifference > difference) {
                delta.position[d] = y + 1;
                delta.t[d] = this.b.get(y);
            } else {
                delta.position[d] = -x - 1;
                delta.t[d] = this.a.get(x);
            }
            difference = newDifference;
        }
        return delta;
    }

    private int calculateDeltaSize() {
        int size = -1;
        int d = 0;
        while (size < 0 && d <= this.max) {
            this.v[d] = new int[2 * d + 1];
            this.from[d] = new boolean[2 * d + 1];
            int k = -d;
            while (k <= d) {
                int x = 0;
                if (d > 0) {
                    if (k == -d || k != d && this.v[d - 1][d - 1 + k - 1] < this.v[d - 1][d - 1 + k + 1]) {
                        x = this.v[d - 1][d - 1 + k + 1];
                        this.from[d][d + k] = true;
                    } else {
                        x = this.v[d - 1][d - 1 + k - 1] + 1;
                        this.from[d][d + k] = false;
                    }
                }
                int y = x - k;
                while (x < this.n && y < this.m && this.equator.equals(this.a.get(x), this.b.get(y))) {
                    ++x;
                    ++y;
                }
                this.v[d][d + k] = x;
                if (x >= this.n && y >= this.m) {
                    size = d;
                }
                k += 2;
            }
            ++d;
        }
        return size;
    }

    public static <T> Delta<T> computeDelta(T[] a, T[] b) {
        return Diff.computeDelta(Arrays.asList(a), Arrays.asList(b));
    }

    public static <T> Delta<T> computeDelta(T[] a, T[] b, IEquator<T> equator) {
        return Diff.computeDelta(Arrays.asList(a), Arrays.asList(b), equator);
    }

    public static <T> Delta<T> computeDelta(List<T> a, List<T> b) {
        return Diff.computeDelta(a, b, DefaultEquator.INSTANCE);
    }

    public static <T> Delta<T> computeDelta(List<T> a, List<T> b, IEquator<T> equator) {
        return super.computeDelta();
    }

    public static class Delta<T> {
        private final int n;
        private final int m;
        private final int[] position;
        private final T[] t;

        private Delta(int size, int n, int m) {
            this.n = n;
            this.m = m;
            this.position = new int[size];
            this.t = new Object[size];
        }

        public int getSize() {
            return this.position.length;
        }

        public int getN() {
            return this.n;
        }

        public int getM() {
            return this.m;
        }

        public T getT(int i) {
            return this.t[i];
        }

        public int getPosition(int i) {
            return this.position[i];
        }

        public List<T> forwardPatch(List<T> a) {
            CCSMPre.isTrue(a.size() == this.n, "Input word must be of size " + this.n);
            return this.doPatch(a, new ArrayList(this.m), 1);
        }

        public List<T> backwardPatch(List<T> b) {
            CCSMPre.isTrue(b.size() == this.m, "Input word must be of size " + this.m);
            return this.doPatch(b, new ArrayList(this.n), -1);
        }

        private List<T> doPatch(List<T> a, List<T> b, int positionFactor) {
            int posA = 0;
            int posB = 0;
            int j = 0;
            while (j < this.position.length) {
                int k = this.position[j] * positionFactor;
                if (k > 0) {
                    --k;
                    while (posB < k) {
                        b.add(a.get(posA));
                        ++posA;
                        ++posB;
                    }
                    b.add(this.t[j]);
                    ++posB;
                } else {
                    k = -k - 1;
                    while (posA < k) {
                        b.add(a.get(posA));
                        ++posA;
                        ++posB;
                    }
                    ++posA;
                }
                ++j;
            }
            while (posA < a.size()) {
                b.add(a.get(posA));
                ++posA;
                ++posB;
            }
            return b;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.position.length) {
                sb.append(Math.abs(this.position[i]) - 1);
                if (this.position[i] > 0) {
                    sb.append("+ ");
                } else {
                    sb.append("- ");
                }
                sb.append(this.t[i] + StringUtils.CR);
                ++i;
            }
            return sb.toString();
        }
    }
}

