/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.algo;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.string.StringUtils;

public class DiffTest
extends TestCase {
    public void testSimple() {
        this.assertDiff(6, "abcdef123ghijklmnopqrstuvwxyz", "abcdefghijklmnop456qrstuvwxyz");
    }

    public void testEqual() {
        this.assertDiff(0, "abcdefabcdefabcdef", "abcdefabcdefabcdef");
    }

    public void testEmpty() {
        this.assertDiff(3, "abc", "");
        this.assertDiff(6, "", "xyzyzy");
        this.assertDiff(0, "", "");
    }

    private void assertDiff(int expectedSize, String wordA, String wordB) {
        List<Character> a = Arrays.asList(StringUtils.splitChars(wordA));
        List<Character> b = Arrays.asList(StringUtils.splitChars(wordB));
        Diff.Delta<Character> delta = Diff.computeDelta(a, b);
        DiffTest.assertEquals((int)expectedSize, (int)delta.getSize());
        DiffTest.assertEquals(b, delta.forwardPatch(a));
        DiffTest.assertEquals(a, delta.backwardPatch(b));
    }
}

