/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.algo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.conqat.lib.commons.algo.MaxWeightMatching;
import org.conqat.lib.commons.collections.PairList;

public class MaxWeightMatchingTest
extends TestCase {
    public void testTrivial() {
        this.assertSolution(new double[][]{{1.0}}, 1);
    }

    public void testSimple() {
        this.assertSolution(new double[][]{{1.0, 2.0}, {2.0, 1.0}}, 4);
    }

    public void testSimpleAugmentation() {
        this.assertSolution(new double[][]{{1.0, 2.0}, {1.0, 4.0}}, 5);
    }

    private void assertSolution(double[][] weight, int solution) {
        ArrayList<Integer> nodes1 = new ArrayList<Integer>();
        ArrayList<Integer> nodes2 = new ArrayList<Integer>();
        int i = 0;
        while (i < weight.length) {
            nodes1.add(i);
            ++i;
        }
        i = 0;
        while (i < weight[0].length) {
            nodes2.add(i);
            ++i;
        }
        double bf = new BruteForceSubSolver<Integer, Integer>(nodes1, nodes2, new ArrayWeightProvider(weight), new PairList()).solve();
        double ap = new MaxWeightMatching<Integer, Integer>().calculateMatching(nodes1, nodes2, new ArrayWeightProvider(weight), new PairList());
        MaxWeightMatchingTest.assertTrue((String)("BF failed (expected: " + solution + ", received: " + bf + ")"), (Math.abs((double)solution - bf) < 1.0E-15 ? 1 : 0) != 0);
        MaxWeightMatchingTest.assertTrue((String)("AP failed (expected: " + solution + ", received: " + ap + ")"), (Math.abs((double)solution - ap) < 1.0E-15 ? 1 : 0) != 0);
    }

    public void testRandom() {
        Random r = new Random(42L);
        int numRuns = 50;
        MaxWeightMatching<Integer, Integer> maxWeightMatching = new MaxWeightMatching<Integer, Integer>();
        int run = 0;
        while (run < 50) {
            double ap;
            int i = 1 + r.nextInt(7);
            int j = 1 + r.nextInt(i);
            double[][] weight = new double[j][i];
            int a = 0;
            while (a < j) {
                int b = 0;
                while (b < i) {
                    weight[a][b] = r.nextDouble();
                    ++b;
                }
                ++a;
            }
            ArrayList<Integer> nodes1 = new ArrayList<Integer>();
            ArrayList<Integer> nodes2 = new ArrayList<Integer>();
            int k = 0;
            while (k < weight.length) {
                nodes1.add(k);
                ++k;
            }
            k = 0;
            while (k < weight[0].length) {
                nodes2.add(k);
                ++k;
            }
            double bf = new BruteForceSubSolver<Integer, Integer>(nodes1, nodes2, new ArrayWeightProvider(weight), new PairList()).solve();
            MaxWeightMatchingTest.assertTrue((Math.abs(bf - (ap = maxWeightMatching.calculateMatching(nodes1, nodes2, new ArrayWeightProvider(weight), new PairList()))) < 1.0E-15 ? 1 : 0) != 0);
            ++run;
        }
    }

    public void testPerformance() {
        Random r = new Random(42L);
        int numRuns = 1000;
        int i = 1;
        while (i <= 7) {
            int j = 1;
            while (j <= i) {
                double[][] weight = new double[j][i];
                int a = 0;
                while (a < j) {
                    int b = 0;
                    while (b < i) {
                        weight[a][b] = r.nextDouble();
                        ++b;
                    }
                    ++a;
                }
                ArrayList<Integer> nodes1 = new ArrayList<Integer>();
                ArrayList<Integer> nodes2 = new ArrayList<Integer>();
                int k = 0;
                while (k < weight.length) {
                    nodes1.add(k);
                    ++k;
                }
                k = 0;
                while (k < weight[0].length) {
                    nodes2.add(k);
                    ++k;
                }
                double bf = 0.0;
                double ap = 0.0;
                long ticksStart = System.currentTimeMillis();
                int k2 = 0;
                while (k2 < 1000) {
                    bf = new BruteForceSubSolver<Integer, Integer>(nodes1, nodes2, new ArrayWeightProvider(weight), new PairList()).solve();
                    ++k2;
                }
                long bfTime = System.currentTimeMillis() - ticksStart;
                ticksStart = System.currentTimeMillis();
                MaxWeightMatching<Integer, Integer> m = new MaxWeightMatching<Integer, Integer>();
                int k3 = 0;
                while (k3 < 1000) {
                    ap = m.calculateMatching(nodes1, nodes2, new ArrayWeightProvider(weight), new PairList());
                    ++k3;
                }
                long apTime = System.currentTimeMillis() - ticksStart;
                System.err.println("Time for " + j + "/" + i + " [bf/ap]: " + bfTime + " " + apTime);
                MaxWeightMatchingTest.assertTrue((Math.abs(ap - bf) < 1.0E-15 ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
    }

    private class ArrayWeightProvider
    implements MaxWeightMatching.IWeightProvider<Integer, Integer> {
        private final double[][] weight;

        public ArrayWeightProvider(double[][] weight) {
            this.weight = weight;
        }

        @Override
        public double getConnectionWeight(Integer node1, Integer node2) {
            return this.weight[node1][node2];
        }
    }

    public static class BruteForceSubSolver<N1, N2> {
        private final int size;
        private final List<N1> nodes1;
        private final List<N2> nodes2;
        private final PairList<N1, N2> result;
        private final MaxWeightMatching.IWeightProvider<N1, N2> weightProvider;
        private double bestSol = Double.NEGATIVE_INFINITY;

        public BruteForceSubSolver(List<N1> nodes1, List<N2> nodes2, MaxWeightMatching.IWeightProvider<N1, N2> weightProvider, PairList<N1, N2> result) {
            if (nodes1.size() > nodes2.size()) {
                throw new IllegalArgumentException();
            }
            this.size = nodes1.size();
            this.nodes1 = new ArrayList<N1>(nodes1);
            this.nodes2 = new ArrayList<N2>(nodes2);
            this.weightProvider = weightProvider;
            this.result = result;
        }

        public double solve() {
            this.result.clear();
            this.bestSol = Double.NEGATIVE_INFINITY;
            return this.solve(0, 0.0);
        }

        private double solve(int currentIndex, double currentSol) {
            if (currentIndex == this.size) {
                if (currentSol > this.bestSol) {
                    this.result.clear();
                    int i = 0;
                    while (i < this.size) {
                        this.result.add(this.nodes1.get(i), this.nodes2.get(i));
                        ++i;
                    }
                    this.bestSol = currentSol;
                }
            } else {
                int i = currentIndex;
                while (i < this.nodes2.size()) {
                    Collections.swap(this.nodes2, i, currentIndex);
                    this.bestSol = this.solve(currentIndex + 1, currentSol + this.weightProvider.getConnectionWeight(this.nodes1.get(currentIndex), this.nodes2.get(currentIndex)));
                    Collections.swap(this.nodes2, i, currentIndex);
                    ++i;
                }
            }
            return this.bestSol;
        }
    }
}

