/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.algo;

import org.conqat.lib.commons.algo.ObjectUnionFind;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class ObjectUnionFindTest
extends CCSMTestCaseBase {
    private ObjectUnionFind<String> unions;

    protected void setUp() {
        this.unions = new ObjectUnionFind();
    }

    public void testUnionTwoElements() {
        this.unions.union("a", "b");
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("a"));
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("b"));
        this.unions.union("a", "b");
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("a"));
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("b"));
        this.unions.union("b", "a");
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("a"));
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("b"));
    }

    public void testTransitiveUnion() {
        this.unions.union("a", "b");
        this.unions.union("b", "c");
        ObjectUnionFindTest.assertEquals((int)3, (int)this.unions.getClusterSize("a"));
        ObjectUnionFindTest.assertEquals((int)3, (int)this.unions.getClusterSize("b"));
        ObjectUnionFindTest.assertEquals((int)3, (int)this.unions.getClusterSize("c"));
        this.unions.union("a", "b");
        this.unions.union("b", "c");
        this.unions.union("c", "b");
        this.unions.union("a", "c");
        this.unions.union("b", "a");
        this.unions.union("c", "a");
        ObjectUnionFindTest.assertEquals((int)3, (int)this.unions.getClusterSize("a"));
        ObjectUnionFindTest.assertEquals((int)3, (int)this.unions.getClusterSize("b"));
        ObjectUnionFindTest.assertEquals((int)3, (int)this.unions.getClusterSize("c"));
    }

    public void testUnionIndependent() {
        this.unions.union("a", "b");
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("a"));
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("b"));
        this.unions.union("x", "y");
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("x"));
        ObjectUnionFindTest.assertEquals((int)2, (int)this.unions.getClusterSize("y"));
        this.unions.union("a", "y");
        ObjectUnionFindTest.assertEquals((int)4, (int)this.unions.getClusterSize("x"));
        ObjectUnionFindTest.assertEquals((int)4, (int)this.unions.getClusterSize("y"));
    }

    public void testUncontainedElements() {
        ObjectUnionFindTest.assertEquals((int)1, (int)this.unions.getClusterSize("a"));
        ObjectUnionFindTest.assertEquals((int)1, (int)this.unions.getClusterSize("a"));
        ObjectUnionFindTest.assertEquals((int)1, (int)this.unions.getClusterSize("b"));
    }
}

