/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.assessment.PartitionedRating;
import org.conqat.lib.commons.assessment.RatingPartition;
import org.conqat.lib.commons.assessment.partition.EmptyLinePartitioner;
import org.conqat.lib.commons.assessment.partition.IRatingPartitioner;
import org.conqat.lib.commons.assessment.partition.PartitioningException;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class PartitionedRatingTest
extends CCSMTestCaseBase {
    public void testMissingPartitioner() {
        try {
            new PartitionedRating("no partitioner given!");
            PartitionedRatingTest.fail((String)"Expected exception");
        }
        catch (PartitioningException e) {
            PartitionedRatingTest.assertTrue((boolean)e.getMessage().contains("No partitioner description found"));
        }
    }

    public void testInvalidPartitioner() {
        try {
            new PartitionedRating(PartitionedRating.createRatingTag("does.not.exist"));
            PartitionedRatingTest.fail((String)"Expected exception");
        }
        catch (PartitioningException e) {
            PartitionedRatingTest.assertTrue((boolean)e.getMessage().startsWith("Could not find partitioner class"));
        }
        try {
            new PartitionedRating(PartitionedRating.createRatingTag(IRatingPartitioner.class.getName()));
            PartitionedRatingTest.fail((String)"Expected exception");
        }
        catch (PartitioningException e) {
            PartitionedRatingTest.assertTrue((boolean)e.getMessage().contains("Could not create"));
        }
        try {
            new PartitionedRating(PartitionedRating.createRatingTag(FileSystemUtils.class.getName()));
            PartitionedRatingTest.fail((String)"Expected exception");
        }
        catch (PartitioningException e) {
            PartitionedRatingTest.assertTrue((boolean)e.getMessage().contains("does not implement"));
        }
    }

    public void testSimpleText() throws PartitioningException {
        UnmodifiableList<RatingPartition> partitions = new PartitionedRating("this is \n a text \n with 3 lines \n\n\n and another one", EmptyLinePartitioner.class).getPartitions();
        PartitionedRatingTest.assertEquals((int)2, (int)partitions.size());
        PartitionedRatingTest.assertRatingPartition("Partition 0", "thisis", 0, 2, null, ETrafficLightColor.RED, partitions.get(0));
        PartitionedRatingTest.assertRatingPartition("Partition 1", "andanotherone", 5, 5, null, ETrafficLightColor.RED, partitions.get(1));
    }

    public void testComplexCase() throws IOException, PartitioningException {
        String content = FileSystemUtils.readFileUTF8(this.useCanonicalTestFile("partitioned_rating.java"));
        UnmodifiableList<RatingPartition> partitions = new PartitionedRating(content).getPartitions();
        PartitionedRatingTest.assertEquals((int)11, (int)partitions.size());
        PartitionedRatingTest.assertRatingPartition("Partition 0", "INITIAL", 0, 24, ETrafficLightColor.GREEN, ETrafficLightColor.GREEN, (RatingPartition)partitions.get(0));
        PartitionedRatingTest.assertRatingPartition("Partition 1", "class start", 26, 35, ETrafficLightColor.BASELINE, ETrafficLightColor.BASELINE, (RatingPartition)partitions.get(1));
        PartitionedRatingTest.assertRatingPartition("Partition 2", "attributes", 37, 40, null, ETrafficLightColor.RED, (RatingPartition)partitions.get(2));
        PartitionedRatingTest.assertRatingPartition("Partition 3", "constructors", 42, 59, ETrafficLightColor.RED, ETrafficLightColor.RED, (RatingPartition)partitions.get(3));
        PartitionedRatingTest.assertRatingPartition("Partition 4", "add methods", 61, 99, null, ETrafficLightColor.RED, (RatingPartition)partitions.get(4));
        PartitionedRatingTest.assertRatingPartition("Partition 5", "getters", 101, 149, null, ETrafficLightColor.RED, (RatingPartition)partitions.get(5));
        PartitionedRatingTest.assertRatingPartition("Partition 6", "toString", 151, 177, ETrafficLightColor.YELLOW, ETrafficLightColor.RED, (RatingPartition)partitions.get(6));
        PartitionedRatingTest.assertRatingPartition("Partition 7", "more utils", 179, 201, ETrafficLightColor.GREEN, ETrafficLightColor.RED, (RatingPartition)partitions.get(7));
        PartitionedRatingTest.assertRatingPartition("Partition 8", "cloning", 203, 216, ETrafficLightColor.RED, ETrafficLightColor.RED, (RatingPartition)partitions.get(8));
        PartitionedRatingTest.assertRatingPartition("Partition 9", "equals/hashCode", 218, 245, ETrafficLightColor.YELLOW, ETrafficLightColor.YELLOW, (RatingPartition)partitions.get(9));
        PartitionedRatingTest.assertRatingPartition("Partition 10", "aggregation", 247, 268, ETrafficLightColor.BASELINE, ETrafficLightColor.RED, (RatingPartition)partitions.get(10));
    }

    public void testOutput() throws IOException, PartitioningException {
        String expected = StringUtils.concat(Arrays.asList("@ConQAT.PartitionedRating org.conqat.lib.commons.assessment.partition.ExplicitPartitioner", "@ConQAT.Partition GREEN Hash: 422E70271AA77888FEE6FE419EB7D635 INITIAL", "@ConQAT.Partition BASELINE Hash: 648AEEE4AB8BAE3D7DBA6B9F1117D047 class start", "@ConQAT.Partition RED Hash:  attributes", "@ConQAT.Partition RED Hash: 60D3D426F6EB225F402A40E92FC13238 constructors", "@ConQAT.Partition RED Hash:  add methods", "@ConQAT.Partition RED Hash:  getters", "@ConQAT.Partition YELLOW Hash: 2BE15CEB8E41F22D1D8EEF1F8F353FB6 toString", "@ConQAT.Partition GREEN Hash: 51CB1EC765DE2C343F0A01E608849803 more utils", "@ConQAT.Partition RED Hash: 659B247C0CCF121208DB568DCF32B99D cloning", "@ConQAT.Partition YELLOW Hash: B4C0A0D2A06DE5C7F4FDBC6F10314854 equals/hashCode", "@ConQAT.Partition BASELINE Hash: BC3492A5174DA9DD9DE86AA31BDB1186 aggregation"), StringUtils.CR);
        String content = FileSystemUtils.readFileUTF8(this.useCanonicalTestFile("partitioned_rating.java"));
        PartitionedRatingTest.assertEquals((String)expected, (String)this.grepTags(new PartitionedRating(content).getUpdatedContent()));
    }

    private String grepTags(String content) {
        ArrayList<String> tags = new ArrayList<String>();
        String[] stringArray = StringUtils.splitLines(content);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int tagStart = line.indexOf("@ConQAT");
            if (tagStart >= 0 && !line.contains("PartitionMark")) {
                tags.add(line.substring(tagStart));
            }
            ++n2;
        }
        return StringUtils.concat(tags, StringUtils.CR);
    }

    private static void assertRatingPartition(String descriptionPrefix, String expectedName, int expectedStartLine, int expectedEndLine, ETrafficLightColor expectedStoredRating, ETrafficLightColor expectedRating, RatingPartition actual) {
        PartitionedRatingTest.assertEquals((String)(String.valueOf(descriptionPrefix) + ": names differ"), (String)expectedName, (String)actual.getName());
        PartitionedRatingTest.assertEquals((String)(String.valueOf(descriptionPrefix) + ": starts differ"), (int)expectedStartLine, (int)actual.getStartLine());
        PartitionedRatingTest.assertEquals((String)(String.valueOf(descriptionPrefix) + ": ends differ"), (int)expectedEndLine, (int)actual.getEndLine());
        PartitionedRatingTest.assertEquals((String)(String.valueOf(descriptionPrefix) + ": stored ratings differ"), (Object)((Object)expectedStoredRating), (Object)((Object)actual.getStoredRating()));
        PartitionedRatingTest.assertEquals((String)(String.valueOf(descriptionPrefix) + ": actual ratings differ"), (Object)((Object)expectedRating), (Object)((Object)actual.getRating()));
    }
}

