/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.assessment.Rating;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public class RatingPartition {
    public static final String PARTITION_TAG = "@ConQAT.Partition";
    private static final Pattern PARTITION_PATTERN = Pattern.compile(".*@ConQAT.Partition +(" + Rating.COLORS_REGEX + ") +Hash: *([a-fA-F0-9]*)( .*)?", 2);
    private ETrafficLightColor storedRating;
    private String hash;
    private final String name;
    private int startLine;
    private int endLine;
    private List<String> content;

    RatingPartition(ETrafficLightColor rating, String hash, String name) {
        this.storedRating = rating;
        this.hash = hash;
        this.name = name;
    }

    void setLinesAndContent(int startLine, int endLine, List<String> content) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public ETrafficLightColor getStoredRating() {
        return this.storedRating;
    }

    public ETrafficLightColor getRating() {
        if (this.storedRating == null || !this.hash.equalsIgnoreCase(this.getExpectedHash())) {
            return ETrafficLightColor.RED;
        }
        return this.getStoredRating();
    }

    private String getExpectedHash() {
        return new Rating(this.content, this.storedRating).getExpectedHashString();
    }

    public void setStoredRatingAndUpdateHash(ETrafficLightColor color) {
        this.storedRating = color;
        this.hash = this.getExpectedHash();
    }

    static RatingPartition processPartitionTag(String line) {
        Matcher matcher = PARTITION_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        ETrafficLightColor color = EnumUtils.valueOfIgnoreCase(ETrafficLightColor.class, matcher.group(1));
        String partitionName = matcher.group(3);
        if (StringUtils.isEmpty(partitionName)) {
            partitionName = "";
        }
        return new RatingPartition(color, matcher.group(2), partitionName.trim());
    }

    String getTag() {
        ETrafficLightColor rating = this.storedRating;
        if (rating == null) {
            rating = ETrafficLightColor.RED;
        }
        return "@ConQAT.Partition " + rating.name() + " Hash: " + this.hash + " " + this.getName();
    }
}

