/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.io.IOException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.assessment.Rating;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class RatingTest
extends CCSMTestCaseBase {
    public void testBasicOperation() {
        this.assertContentRating("contains no tag", null, ETrafficLightColor.RED);
        ETrafficLightColor[] eTrafficLightColorArray = ETrafficLightColor.values();
        int n = eTrafficLightColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ETrafficLightColor color = eTrafficLightColorArray[n2];
            String content = "Test file\n" + Rating.constructRatingTag(color, "");
            this.assertContentRating(content, color, ETrafficLightColor.RED);
            content = Rating.updateRating(content, color);
            this.assertContentRating(content, color, color);
            ++n2;
        }
    }

    public void testIgnoredRegions() {
        this.assertReplacementIgnoranceWorks("ignored text\npackage foo.bar.baz;\nsome more text\n", "ignored", "irrelevant");
        this.assertReplacementIgnoranceWorks("   indent \n how you like\n", " ", "  ");
        this.assertReplacementIgnoranceWorks("some $ignored$ text\n", "ignored", "irrelevant");
        this.assertReplacementIgnoranceWorks("some weird \u0123 char\n", "\u0123", "\u0124");
    }

    private void assertReplacementIgnoranceWorks(String baseText, String replacee, String replacement) {
        String content = String.valueOf(baseText) + "\n" + Rating.constructRatingTag(ETrafficLightColor.YELLOW, "");
        content = Rating.updateRating(content, ETrafficLightColor.YELLOW);
        this.assertContentRating(content, ETrafficLightColor.YELLOW, ETrafficLightColor.YELLOW);
        content = content.replace(replacee, replacement);
        this.assertContentRating(content, ETrafficLightColor.YELLOW, ETrafficLightColor.YELLOW);
    }

    public void testColorDependency() {
        String content = "Test file\n" + Rating.constructRatingTag(ETrafficLightColor.YELLOW, "");
        content = Rating.updateRating(content, ETrafficLightColor.YELLOW);
        this.assertContentRating(content, ETrafficLightColor.YELLOW, ETrafficLightColor.YELLOW);
        content = content.replace(ETrafficLightColor.YELLOW.name(), ETrafficLightColor.GREEN.name());
        this.assertContentRating(content, ETrafficLightColor.GREEN, ETrafficLightColor.RED);
    }

    public void testNewStyle() throws IOException {
        this.assertFileRating("newstyle_baseline_invalid.java", ETrafficLightColor.BASELINE, ETrafficLightColor.RED);
        this.assertFileRating("newstyle_baseline_valid.java", ETrafficLightColor.BASELINE, ETrafficLightColor.BASELINE);
        this.assertFileRating("newstyle_green_invalid.java", ETrafficLightColor.GREEN, ETrafficLightColor.RED);
        this.assertFileRating("newstyle_green_valid.java", ETrafficLightColor.GREEN, ETrafficLightColor.GREEN);
        this.assertFileRating("newstyle_red.java", ETrafficLightColor.RED, ETrafficLightColor.RED);
        this.assertFileRating("newstyle_yellow_invalid.java", ETrafficLightColor.YELLOW, ETrafficLightColor.RED);
        this.assertFileRating("newstyle_yellow_valid.java", ETrafficLightColor.YELLOW, ETrafficLightColor.YELLOW);
    }

    public void testOldStyle() throws IOException {
        this.assertFileRating("oldstyle_green_invalid.java", ETrafficLightColor.GREEN, ETrafficLightColor.RED);
        this.assertFileRating("oldstyle_green_valid.java", ETrafficLightColor.GREEN, ETrafficLightColor.GREEN);
        this.assertFileRating("oldstyle_red.java", ETrafficLightColor.RED, ETrafficLightColor.RED);
        this.assertFileRating("oldstyle_yellow_invalid.java", ETrafficLightColor.YELLOW, ETrafficLightColor.RED);
        this.assertFileRating("oldstyle_yellow_valid.java", ETrafficLightColor.YELLOW, ETrafficLightColor.YELLOW);
    }

    public void testNoRating() throws IOException {
        this.assertFileRating("no_rating.java", null, ETrafficLightColor.RED);
    }

    public void testRatingReplacement() throws IOException {
        RatingTest.assertNull((Object)Rating.updateRating("no rating provided", ETrafficLightColor.BASELINE));
        String actual = FileSystemUtils.readFile(this.useTestFile("newstyle_green_invalid.java"));
        String expected = FileSystemUtils.readFile(this.useTestFile("newstyle_green_valid.java"));
        RatingTest.assertEquals((String)expected, (String)Rating.updateRating(actual, ETrafficLightColor.GREEN));
    }

    private void assertFileRating(String filename, ETrafficLightColor containedColor, ETrafficLightColor ratingColor) throws IOException {
        String content = FileSystemUtils.readFile(this.useTestFile(filename));
        this.assertContentRating(content, containedColor, ratingColor);
    }

    private void assertContentRating(String content, ETrafficLightColor containedColor, ETrafficLightColor ratingColor) {
        Rating rating = new Rating(content);
        RatingTest.assertEquals((Object)((Object)containedColor), (Object)((Object)rating.getStoredRating()));
        RatingTest.assertEquals((Object)((Object)ratingColor), (Object)((Object)rating.getRating()));
    }
}

