/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.cache4j.CacheRuleParsingException;
import org.conqat.lib.commons.cache4j.ECacheThreadSupport;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.backend.ECachingStrategy;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.factory.IParameterizedFactory;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CacheFactory {
    private static final int CLEANUP_INTERVAL = 100;
    private static final Pattern RULE_PATTERN = Pattern.compile("([^\\s]+)\\s*->\\s*([^\\s:]+):([^\\s:]+):([0-9]+)");
    private static final CacheFactory INSTANCE = new CacheFactory();
    private final List<CacheInfo> caches = new ArrayList<CacheInfo>();
    private final List<CacheCreationRule> rules = new LinkedList<CacheCreationRule>();
    private CacheCreationRule defaultRule = new CacheCreationRule("", ECacheThreadSupport.NONE, ECachingStrategy.OFF, 0);
    private int creationCount = 0;

    private CacheFactory() {
    }

    public static CacheFactory getInstance() {
        return INSTANCE;
    }

    public void setDefaultRule(CacheCreationRule rule) {
        CCSMPre.isNotNull(rule);
        this.defaultRule = rule;
    }

    public void loadCacheConfiguration(File file) throws IOException, CacheRuleParsingException {
        this.loadCacheConfiguration(FileSystemUtils.readFileUTF8(file));
    }

    public void loadCacheConfiguration(String config) throws CacheRuleParsingException {
        this.loadCacheConfiguration(StringUtils.splitLines(config));
    }

    public void loadCacheConfiguration(String[] lines) throws CacheRuleParsingException {
        this.clearRules();
        int lineNumber = 0;
        while (lineNumber < lines.length) {
            String line = lines[lineNumber];
            if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                try {
                    this.addRuleBack(this.parseRule(line));
                }
                catch (CacheRuleParsingException e) {
                    e.setLine(lineNumber + 1);
                    throw e;
                }
            }
            ++lineNumber;
        }
    }

    private CacheCreationRule parseRule(String line) throws CacheRuleParsingException {
        Matcher matcher = RULE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new CacheRuleParsingException("Line does not follow definition pattern!");
        }
        String pattern = matcher.group(1);
        ECacheThreadSupport threadSupport = EnumUtils.valueOfIgnoreCase(ECacheThreadSupport.class, matcher.group(2));
        if (threadSupport == null) {
            throw new CacheRuleParsingException("Unknown thread support: " + matcher.group(2));
        }
        ECachingStrategy cachingStrategy = EnumUtils.valueOfIgnoreCase(ECachingStrategy.class, matcher.group(3));
        if (cachingStrategy == null) {
            throw new CacheRuleParsingException("Unknown caching strategy: " + matcher.group(3));
        }
        try {
            return new CacheCreationRule(pattern, threadSupport, cachingStrategy, Integer.parseInt(matcher.group(4)));
        }
        catch (PatternSyntaxException e) {
            throw new CacheRuleParsingException("Could not parse pattern: " + e.getMessage(), e);
        }
        catch (NumberFormatException e) {
            throw new CacheRuleParsingException("Could not parse parameter: " + e.getMessage(), e);
        }
    }

    public void clearRules() {
        this.rules.clear();
    }

    public void addRuleFront(CacheCreationRule rule) {
        this.rules.add(0, rule);
    }

    public void addRuleBack(CacheCreationRule rule) {
        this.rules.add(rule);
    }

    public static <K, V, X extends Exception> ICache<K, V, X> obtainCache(String name, IParameterizedFactory<V, K, X> factory) {
        return CacheFactory.getInstance().obtainCacheByRules(name, factory);
    }

    private synchronized <K, V, X extends Exception> ICache<K, V, X> obtainCacheByRules(String name, IParameterizedFactory<V, K, X> factory) {
        CacheCreationRule usedRule = this.defaultRule;
        for (CacheCreationRule rule : this.rules) {
            if (!rule.matches(name)) continue;
            usedRule = rule;
            break;
        }
        ICache<K, V, X> cache = usedRule.createCache(name, factory);
        ++this.creationCount;
        if (this.creationCount % 100 == 0) {
            this.cleanCaches();
        }
        this.caches.add(new CacheInfo(cache, usedRule));
        return cache;
    }

    private void cleanCaches() {
        ArrayList<CacheInfo> copy = new ArrayList<CacheInfo>(this.caches);
        this.caches.clear();
        for (CacheInfo cache : copy) {
            if (!cache.isAlive()) continue;
            this.caches.add(cache);
        }
    }

    public static <K, V, X extends Exception> ICache<K, V, X> obtainCache(Class<?> clazz, IParameterizedFactory<V, K, X> factory) {
        return CacheFactory.obtainCache(clazz.getName(), factory);
    }

    public String getStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name;Thread Support;Cache Strategy; Strategy Parameter; Hits; Misses; Miss Cost Millis" + StringUtils.CR);
        for (CacheInfo cache : new ArrayList<CacheInfo>(this.caches)) {
            cache.appendStatistics(sb);
        }
        return sb.toString();
    }

    void clearCaches() {
        this.caches.clear();
    }

    public static final class CacheCreationRule {
        private final Pattern pattern;
        private final ECacheThreadSupport threadSupport;
        private final ECachingStrategy cachingStrategy;
        private final int cachingStrategyParameter;

        public CacheCreationRule(Pattern pattern, ECacheThreadSupport threadSupport, ECachingStrategy cachingStrategy, int cachingStrategyParameter) {
            this.pattern = pattern;
            this.threadSupport = threadSupport;
            this.cachingStrategy = cachingStrategy;
            this.cachingStrategyParameter = cachingStrategyParameter;
        }

        public CacheCreationRule(String pattern, ECacheThreadSupport threadSupport, ECachingStrategy cachingStrategy, int cachingStrategyParameter) throws PatternSyntaxException {
            this(Pattern.compile(pattern), threadSupport, cachingStrategy, cachingStrategyParameter);
        }

        public boolean matches(String name) {
            return this.pattern.matcher(name).matches();
        }

        public <K, V, X extends Exception> ICache<K, V, X> createCache(String name, IParameterizedFactory<V, K, X> factory) {
            return this.threadSupport.createCache(name, factory, this.cachingStrategy.getBackend(this.cachingStrategyParameter));
        }
    }

    private static final class CacheInfo {
        private final WeakReference<ICache<?, ?, ?>> cacheRef;
        private final CacheCreationRule creationRule;

        public CacheInfo(ICache<?, ?, ?> cache, CacheCreationRule creationRule) {
            this.cacheRef = new WeakReference(cache);
            this.creationRule = creationRule;
        }

        public boolean isAlive() {
            return this.cacheRef.get() != null;
        }

        public void appendStatistics(StringBuilder sb) {
            ICache cache = (ICache)this.cacheRef.get();
            if (cache == null) {
                return;
            }
            sb.append(String.valueOf(cache.getName()) + ";" + this.creationRule.threadSupport.name() + ";" + this.creationRule.cachingStrategy.name() + ";" + this.creationRule.cachingStrategyParameter + ";" + cache.getHits() + ";" + cache.getMisses() + ";" + cache.getMissCostMillis() + StringUtils.CR);
        }
    }
}

