/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Set;
import org.conqat.lib.commons.collections.ArrayBackedMap;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class ArrayBackedMapTest
extends CCSMTestCaseBase {
    public void testSize() {
        ArrayBackedMap<Integer, Integer> map = new ArrayBackedMap<Integer, Integer>();
        ArrayBackedMapTest.assertTrue((boolean)map.isEmpty());
        ArrayBackedMapTest.assertEquals((int)0, (int)map.size());
        map.put(1, 1);
        ArrayBackedMapTest.assertFalse((boolean)map.isEmpty());
        ArrayBackedMapTest.assertEquals((int)1, (int)map.size());
        map.put(2, 2);
        ArrayBackedMapTest.assertFalse((boolean)map.isEmpty());
        ArrayBackedMapTest.assertEquals((int)2, (int)map.size());
        map.put(1, 3);
        ArrayBackedMapTest.assertFalse((boolean)map.isEmpty());
        ArrayBackedMapTest.assertEquals((int)2, (int)map.size());
        map.remove(2);
        ArrayBackedMapTest.assertFalse((boolean)map.isEmpty());
        ArrayBackedMapTest.assertEquals((int)1, (int)map.size());
        map.remove(2);
        ArrayBackedMapTest.assertFalse((boolean)map.isEmpty());
        ArrayBackedMapTest.assertEquals((int)1, (int)map.size());
        map.remove(1);
        ArrayBackedMapTest.assertTrue((boolean)map.isEmpty());
        ArrayBackedMapTest.assertEquals((int)0, (int)map.size());
    }

    public void testStore() {
        ArrayBackedMap<Integer, Integer> map = new ArrayBackedMap<Integer, Integer>();
        int i = 0;
        while (i < 5) {
            map.put(i, i * i + 1);
            ++i;
        }
        i = 0;
        while (i < 5) {
            ArrayBackedMapTest.assertTrue((boolean)map.containsKey(i));
            ArrayBackedMapTest.assertEquals((Object)(i * i + 1), map.get(i));
            ++i;
        }
        ArrayBackedMapTest.assertTrue((!map.containsKey(6) ? 1 : 0) != 0);
        ArrayBackedMapTest.assertNull(map.get(6));
        ArrayBackedMapTest.assertTrue((!map.containsKey("Foo") ? 1 : 0) != 0);
        ArrayBackedMapTest.assertNull(map.get("Foo"));
        i = 0;
        while (i < 5) {
            map.put(i, 3 * i);
            ++i;
        }
        i = 0;
        while (i < 5) {
            ArrayBackedMapTest.assertTrue((boolean)map.containsKey(i));
            ArrayBackedMapTest.assertEquals((Object)(3 * i), map.get(i));
            ++i;
        }
        i = 0;
        while (i < 5) {
            ArrayBackedMapTest.assertEquals((Object)(3 * i), map.remove(i));
            ++i;
        }
        ArrayBackedMapTest.assertNull(map.remove(6));
        ArrayBackedMapTest.assertNull(map.remove("Foo"));
        ArrayBackedMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testSets() {
        ArrayBackedMap<Integer, Integer> map = new ArrayBackedMap<Integer, Integer>();
        int i = 0;
        while (i < 10) {
            map.put(i, i);
            ++i;
        }
        Set keys = map.keySet();
        ArrayBackedMapTest.assertEquals((int)10, (int)keys.size());
        int i2 = 0;
        while (i2 < 10) {
            ArrayBackedMapTest.assertTrue((boolean)map.containsKey(i2));
            ++i2;
        }
    }
}

