/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.collections.BoundedPriorityQueue;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class BoundedPriorityQueueTest
extends CCSMTestCaseBase {
    public void testAddLessThanCapacity() {
        this.assertTopValuesForCapacity5(Arrays.asList(1, 5, 3), Arrays.asList(1, 5, 3));
    }

    public void testAddExactlyCapacity() {
        this.assertTopValuesForCapacity5(Arrays.asList(1, 5, 3, 2, 4), Arrays.asList(1, 5, 3, 2, 4));
    }

    public void testAddMoreThanCapacity() {
        this.assertTopValuesForCapacity5(Arrays.asList(1, 5, 3, 2, 4, 6, 7, 8), Arrays.asList(4, 5, 6, 7, 8));
        this.assertTopValuesForCapacity5(Arrays.asList(8, 7, 6, 5, 4, 3, 2, 1), Arrays.asList(4, 5, 6, 7, 8));
    }

    private void assertTopValuesForCapacity5(List<Integer> values, List<Integer> topValues) {
        this.assertTopValues(values, topValues, 5);
    }

    private void assertTopValues(List<Integer> values, List<Integer> topValues, int capacity) {
        BoundedPriorityQueue<Integer> list = new BoundedPriorityQueue<Integer>(capacity, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        });
        List<Integer> expected = CollectionUtils.sort(topValues);
        list.addAll(values);
        BoundedPriorityQueueTest.assertEquals(expected, CollectionUtils.sort(list));
    }
}

