/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.List;
import javax.swing.JFrame;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.ClassHierarchyMap;

public class ClassHierarchyMapTest
extends TestCase {
    public void testGet() {
        ClassHierarchyMap<Object, String> map = new ClassHierarchyMap<Object, String>();
        ClassHierarchyMapTest.assertNull(map.get(""));
        ClassHierarchyMapTest.assertNull(map.get((Object)String.class));
        map.put(Object.class, "object");
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.get((Object)Object.class)));
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.get(new Object())));
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.get((Object)String.class)));
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.get("")));
        map.put(String.class, "string");
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.get((Object)Object.class)));
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.get(new Object())));
        ClassHierarchyMapTest.assertEquals((String)"string", (String)((String)map.get((Object)String.class)));
        ClassHierarchyMapTest.assertEquals((String)"string", (String)((String)map.get("")));
    }

    public void testGetDeclared() {
        ClassHierarchyMap<Object, String> map = new ClassHierarchyMap<Object, String>();
        ClassHierarchyMapTest.assertNull(map.get(""));
        ClassHierarchyMapTest.assertNull(map.get((Object)String.class));
        map.put(Object.class, "object");
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.getDeclared((Object)Object.class)));
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.getDeclared(new Object())));
        ClassHierarchyMapTest.assertNull(map.getDeclared((Object)String.class));
        ClassHierarchyMapTest.assertNull(map.getDeclared(""));
        map.put(String.class, "string");
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.getDeclared((Object)Object.class)));
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.getDeclared(new Object())));
        ClassHierarchyMapTest.assertEquals((String)"string", (String)((String)map.getDeclared((Object)String.class)));
        ClassHierarchyMapTest.assertEquals((String)"string", (String)((String)map.getDeclared("")));
    }

    public void testGetAllDeepHierarchy() {
        ClassHierarchyMap<Object, String> map = new ClassHierarchyMap<Object, String>();
        map.put(JFrame.class, "JFrame");
        map.put(Container.class, "Container");
        map.put(Component.class, "Component");
        List list = map.getAll((Object)JFrame.class);
        ClassHierarchyMapTest.assertEquals((int)3, (int)list.size());
        ClassHierarchyMapTest.assertEquals((String)"JFrame", (String)((String)list.get(0)));
        ClassHierarchyMapTest.assertEquals((String)"Container", (String)((String)list.get(1)));
        ClassHierarchyMapTest.assertEquals((String)"Component", (String)((String)list.get(2)));
        list = map.getAll((Object)Window.class);
        ClassHierarchyMapTest.assertEquals((int)2, (int)list.size());
        ClassHierarchyMapTest.assertEquals((String)"Container", (String)((String)list.get(0)));
        ClassHierarchyMapTest.assertEquals((String)"Component", (String)((String)list.get(1)));
        list = map.getAll((Object)Object.class);
        ClassHierarchyMapTest.assertTrue((boolean)list.isEmpty());
    }

    public void testGetAllShallowHierarchy() {
        ClassHierarchyMap<Object, String> map = new ClassHierarchyMap<Object, String>();
        map.put(Object.class, "object");
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)map.get((Object)String.class)));
        map.put(String.class, "string");
        ClassHierarchyMapTest.assertEquals((String)"string", (String)((String)map.get((Object)String.class)));
        List list = map.getAll((Object)String.class);
        ClassHierarchyMapTest.assertEquals((int)2, (int)list.size());
        ClassHierarchyMapTest.assertEquals((String)"string", (String)((String)list.get(0)));
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)list.get(1)));
        list = map.getAll("");
        ClassHierarchyMapTest.assertEquals((int)2, (int)list.size());
        ClassHierarchyMapTest.assertEquals((String)"string", (String)((String)list.get(0)));
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)list.get(1)));
        list = map.getAll((Object)Object.class);
        ClassHierarchyMapTest.assertEquals((int)1, (int)list.size());
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)list.get(0)));
        list = map.getAll(new Object());
        ClassHierarchyMapTest.assertEquals((int)1, (int)list.size());
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)list.get(0)));
        list = map.getAll((Object)Integer.class);
        ClassHierarchyMapTest.assertEquals((int)1, (int)list.size());
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)list.get(0)));
        list = map.getAll(1);
        ClassHierarchyMapTest.assertEquals((int)1, (int)list.size());
        ClassHierarchyMapTest.assertEquals((String)"object", (String)((String)list.get(0)));
    }
}

