/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class CollectionMapTest
extends CCSMTestCaseBase {
    private CollectionMap<String, String, Set<String>> map;

    protected void setUp() {
        this.map = new CollectionMap(new IFactory<Set<String>, NeverThrownRuntimeException>(){

            @Override
            public Set<String> create() {
                return new HashSet<String>();
            }
        });
        this.map.add("test1", "test1_0");
        this.map.add("test1", "test1_1");
        this.map.add("test2", "test2_0");
        this.map.add("test2", "test2_1");
        this.map.add("test2", "test2_2");
    }

    public void testContains() {
        CollectionMapTest.assertTrue((boolean)this.map.contains("test1", "test1_0"));
        CollectionMapTest.assertTrue((boolean)this.map.contains("test1", "test1_1"));
        CollectionMapTest.assertFalse((boolean)this.map.contains("test1", "test1_3"));
        CollectionMapTest.assertFalse((boolean)this.map.contains("test2", "test1_0"));
        CollectionMapTest.assertFalse((boolean)this.map.contains("test3", "test1_0"));
        CollectionMapTest.assertTrue((boolean)this.map.containsCollection("test1"));
        CollectionMapTest.assertTrue((boolean)this.map.containsCollection("test2"));
        CollectionMapTest.assertFalse((boolean)this.map.containsCollection("test3"));
    }

    public void testGet() {
        CollectionMapTest.assertEquals(CollectionUtils.asHashSet("test1_0", "test1_1"), this.map.getCollection("test1"));
        CollectionMapTest.assertEquals(CollectionUtils.asHashSet("test1", "test2"), this.map.getKeys());
        CollectionMapTest.assertEquals(CollectionUtils.asHashSet("test1_0", "test1_1", "test2_0", "test2_1", "test2_2"), this.map.getValues());
    }

    public void testAddAll() {
        this.map.addAll("test1", Arrays.asList("a", "b", "c"));
        CollectionMapTest.assertEquals((int)5, (int)this.map.getCollection("test1").size());
        this.map.addAll("test1", Arrays.asList("test1_0", "x", "a", "b", "c"));
        CollectionMapTest.assertEquals((int)6, (int)this.map.getCollection("test1").size());
    }

    public void testRemove() {
        CollectionMapTest.assertFalse((boolean)this.map.remove("a", "b"));
        CollectionMapTest.assertFalse((boolean)this.map.remove("test1", "b"));
        CollectionMapTest.assertEquals(CollectionUtils.asHashSet("test1_0", "test1_1"), this.map.getCollection("test1"));
        CollectionMapTest.assertTrue((boolean)this.map.remove("test1", "test1_1"));
        CollectionMapTest.assertEquals(CollectionUtils.asHashSet("test1_0"), this.map.getCollection("test1"));
        CollectionMapTest.assertFalse((boolean)this.map.removeCollection("a"));
        CollectionMapTest.assertTrue((boolean)this.map.removeCollection("test2"));
        CollectionMapTest.assertEquals(CollectionUtils.asHashSet("test1"), this.map.getKeys());
    }

    public void testListToArrays() {
        Map<String, String[]> arrayMap = this.map.collectionsToArrays(String.class);
        CollectionMapTest.assertTrue((arrayMap.keySet().size() == 2 ? 1 : 0) != 0);
        CollectionMapTest.assertTrue((arrayMap.get("test1").length == 2 ? 1 : 0) != 0);
        CollectionMapTest.assertTrue((arrayMap.get("test2").length == 3 ? 1 : 0) != 0);
    }

    public void testToString() {
        CollectionMapTest.assertEquals((String)"{test1=[test1_0, test1_1], test2=[test2_0, test2_2, test2_1]}", (String)this.map.toString());
    }
}

