/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class CounterSet<E> {
    protected final Map<E, Integer> map = new LinkedHashMap<E, Integer>();
    protected int total = 0;

    public void inc(E key, int increment) {
        Integer value = this.map.get(key);
        int newValue = value == null ? increment : value + increment;
        this.map.put(key, newValue);
        this.total += increment;
    }

    public void inc(E key) {
        this.inc(key, 1);
    }

    public void incAll(Collection<E> keys) {
        for (E key : keys) {
            this.inc(key);
        }
    }

    public void remove(E key) {
        this.total -= this.getValue(key);
        this.map.remove(key);
    }

    public boolean contains(E key) {
        return this.map.containsKey(key);
    }

    public int getValue(E key) {
        Integer value = this.map.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public UnmodifiableSet<E> getKeys() {
        return CollectionUtils.asUnmodifiable(this.map.keySet());
    }

    public int getTotal() {
        return this.total;
    }

    public String toString() {
        return this.map.toString();
    }
}

