/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class IdentityHashSet<E>
extends AbstractSet<E> {
    private static final Object PRESENT = new Object();
    private final IdentityHashMap<E, Object> map;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends E> collection) {
        this(collection.size());
        for (E e : collection) {
            this.add(e);
        }
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.map = new IdentityHashMap(expectedMaxSize);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public IdentityHashSet<E> clone() {
        return new IdentityHashSet<E>(this);
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

