/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import org.conqat.lib.commons.clone.CloneUtils;
import org.conqat.lib.commons.clone.DeepCloneException;
import org.conqat.lib.commons.clone.IDeepCloneable;

public class ImmutablePair<S, T>
implements Cloneable,
IDeepCloneable,
Comparable<ImmutablePair<S, T>>,
Serializable {
    protected S first;
    protected T second;

    public ImmutablePair(S first, T second) {
        this.first = first;
        this.second = second;
    }

    public ImmutablePair(ImmutablePair<S, T> p) {
        this.first = p.first;
        this.second = p.second;
    }

    public S getFirst() {
        return this.first;
    }

    public T getSecond() {
        return this.second;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImmutablePair)) {
            return false;
        }
        ImmutablePair p = (ImmutablePair)obj;
        return this.areEqual(this.first, p.first) && this.areEqual(this.second, p.second);
    }

    private boolean areEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        int firstCode = 1;
        if (this.first != null) {
            firstCode = this.first.hashCode();
        }
        int secondCode = 1;
        if (this.second != null) {
            secondCode = this.second.hashCode();
        }
        return firstCode + 1013 * secondCode;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + ")";
    }

    protected ImmutablePair<S, T> clone() {
        return new ImmutablePair<S, T>(this);
    }

    @Override
    public ImmutablePair<S, T> deepClone() throws DeepCloneException {
        Object newFirst = CloneUtils.cloneAsDeepAsPossible(this.first);
        Object newSecond = CloneUtils.cloneAsDeepAsPossible(this.second);
        return new ImmutablePair<Object, Object>(newFirst, newSecond);
    }

    @Override
    public int compareTo(ImmutablePair<S, T> pair) {
        int cmp = this.objCompare(this.first, pair.first);
        if (cmp != 0) {
            return cmp;
        }
        return this.objCompare(this.second, pair.second);
    }

    private <O> int objCompare(O o1, O o2) {
        int h2;
        int h1;
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            try {
                ((Comparable)o1).compareTo(o2);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if ((h1 = o1.hashCode()) == (h2 = o2.hashCode())) {
            return 0;
        }
        if (h1 < h2) {
            return -1;
        }
        return 1;
    }
}

