/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMPre;

public class PairList<S, T>
implements Serializable {
    private int size = 0;
    private Object[] firstElements;
    private Object[] secondElements;

    public PairList() {
        this(16);
    }

    public PairList(int initialCapacity) {
        if (initialCapacity < 1) {
            initialCapacity = 1;
        }
        this.firstElements = new Object[initialCapacity];
        this.secondElements = new Object[initialCapacity];
    }

    public PairList(PairList<S, T> other) {
        this(other.size);
        this.addAll(other);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void add(S first, T second) {
        this.ensureSpace(this.size + 1);
        this.firstElements[this.size] = first;
        this.secondElements[this.size] = second;
        ++this.size;
    }

    public void addAll(PairList<S, T> other) {
        int otherSize = other.size;
        this.ensureSpace(this.size + otherSize);
        int i = 0;
        while (i < otherSize) {
            this.firstElements[this.size] = other.firstElements[i];
            this.secondElements[this.size] = other.secondElements[i];
            ++this.size;
            ++i;
        }
    }

    protected void ensureSpace(int space) {
        if (space <= this.firstElements.length) {
            return;
        }
        Object[] oldFirst = this.firstElements;
        Object[] oldSecond = this.secondElements;
        int newSize = this.firstElements.length * 2;
        while (newSize < space) {
            newSize *= 2;
        }
        this.firstElements = new Object[newSize];
        this.secondElements = new Object[newSize];
        System.arraycopy(oldFirst, 0, this.firstElements, 0, this.size);
        System.arraycopy(oldSecond, 0, this.secondElements, 0, this.size);
    }

    public S getFirst(int i) {
        this.checkWithinBounds(i);
        return (S)this.firstElements[i];
    }

    private void checkWithinBounds(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException("Out of bounds: " + i);
        }
    }

    public void setFirst(int i, S value) {
        this.checkWithinBounds(i);
        this.firstElements[i] = value;
    }

    public T getSecond(int i) {
        this.checkWithinBounds(i);
        return (T)this.secondElements[i];
    }

    public void setSecond(int i, T value) {
        this.checkWithinBounds(i);
        this.secondElements[i] = value;
    }

    public List<S> extractFirstList() {
        ArrayList<Object> result = new ArrayList<Object>(this.size + 1);
        int i = 0;
        while (i < this.size) {
            result.add(this.firstElements[i]);
            ++i;
        }
        return result;
    }

    public List<T> extractSecondList() {
        ArrayList<Object> result = new ArrayList<Object>(this.size + 1);
        int i = 0;
        while (i < this.size) {
            result.add(this.secondElements[i]);
            ++i;
        }
        return result;
    }

    public void swapPairs() {
        Object[] temp = this.firstElements;
        this.firstElements = this.secondElements;
        this.secondElements = temp;
    }

    public void swapEntries(int i, int j) {
        S tmp1 = this.getFirst(i);
        T tmp2 = this.getSecond(i);
        this.setFirst(i, this.getFirst(j));
        this.setSecond(i, this.getSecond(j));
        this.setFirst(j, tmp1);
        this.setSecond(j, tmp2);
    }

    public void clear() {
        this.size = 0;
    }

    public void removeLast() {
        CCSMPre.isTrue(this.size > 0, "Size must be positive!");
        --this.size;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('[');
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                result.append(',');
            }
            result.append('(');
            result.append(String.valueOf(this.firstElements[i]));
            result.append(',');
            result.append(String.valueOf(this.secondElements[i]));
            result.append(')');
            ++i;
        }
        result.append(']');
        return result.toString();
    }
}

