/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import junit.framework.TestCase;
import org.conqat.lib.commons.collections.PairList;

public class PairListTest
extends TestCase {
    public void testClear() {
        PairList<Integer, String> p = this.createFilledPairList(100);
        p.clear();
        PairListTest.assertEquals((int)0, (int)p.size());
        PairListTest.assertTrue((boolean)p.isEmpty());
    }

    public void testAddAll() {
        PairList<Integer, String> p = this.createFilledPairList(99);
        p.addAll(p);
        PairListTest.assertEquals((int)198, (int)p.size());
        int i = 0;
        while (i < 99) {
            PairListTest.assertEquals((int)i, (int)p.getFirst(i));
            PairListTest.assertEquals((String)String.valueOf(i), (String)p.getSecond(i));
            PairListTest.assertEquals((int)i, (int)p.getFirst(i + 99));
            PairListTest.assertEquals((String)String.valueOf(i), (String)p.getSecond(i + 99));
            ++i;
        }
    }

    public void testRemoveLast() {
        PairList<Integer, String> p = this.createFilledPairList(100);
        p.removeLast();
        this.assertListContent(p, 99);
    }

    public void testAdd() {
        PairList<Integer, String> p = this.createFilledPairList(100);
        this.assertListContent(p, 100);
    }

    public void testSwapEntries() {
        PairList<Integer, String> p = this.createFilledPairList(100);
        this.assertListContent(p, 100);
        p.swapEntries(40, 40);
        this.assertListContent(p, 100);
        p.swapEntries(37, 65);
        PairListTest.assertEquals((Object)p.getFirst(37), (Object)65);
        PairListTest.assertEquals((Object)p.getFirst(65), (Object)37);
        PairListTest.assertEquals((String)p.getSecond(37), (String)"65");
        PairListTest.assertEquals((String)p.getSecond(65), (String)"37");
        p.swapEntries(37, 65);
        this.assertListContent(p, 100);
    }

    public void testToString() {
        PairList<Integer, String> p = this.createFilledPairList(2);
        PairListTest.assertEquals((String)"[(0,0),(1,1)]", (String)p.toString());
    }

    public void testToStringWithNull() {
        PairList<Integer, String> p = this.createFilledPairList(2);
        p.setFirst(0, null);
        p.setSecond(1, null);
        PairListTest.assertEquals((String)"[(null,0),(1,null)]", (String)p.toString());
    }

    private PairList<Integer, String> createFilledPairList(int length) {
        PairList<Integer, String> p = new PairList<Integer, String>();
        int i = 0;
        while (i < length) {
            p.add(i, String.valueOf(i));
            ++i;
        }
        return p;
    }

    private void assertListContent(PairList<Integer, String> p, int length) {
        PairListTest.assertEquals((int)length, (int)p.size());
        int i = 0;
        while (i < length) {
            PairListTest.assertEquals((int)i, (int)p.getFirst(i));
            PairListTest.assertEquals((String)String.valueOf(i), (String)p.getSecond(i));
            ++i;
        }
    }
}

