/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.ISortableData;
import org.conqat.lib.commons.collections.SortableDataUtils;

public class SortableDataUtilsTest
extends TestCase {
    public void testQuickSort() {
        this.testSorting(false);
    }

    public void testBubbleSort() {
        this.testSorting(true);
    }

    private void testSorting(boolean bubbleSort) {
        int size = 100;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < 100) {
            list.add(i);
            ++i;
        }
        Collections.shuffle(list);
        if (bubbleSort) {
            SortableDataUtils.bubbleSort(new SortableDataList(list, list.size()), 0, list.size());
        } else {
            SortableDataUtils.sort(new SortableDataList(list, list.size()));
        }
        SortableDataUtilsTest.assertEquals((int)100, (int)list.size());
        i = 0;
        while (i < 100) {
            SortableDataUtilsTest.assertEquals((int)i, (int)((Integer)list.get(i)));
            ++i;
        }
    }

    public void testEqualData() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < 100) {
            int j = 0;
            while (j < 10) {
                list.add(j);
                ++j;
            }
            ++i;
        }
        SortableDataUtils.sort(new SortableDataList(list, list.size()));
    }

    public void testEmpty() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        SortableDataUtils.sort(new SortableDataList(list, list.size()));
        list.add(0);
        SortableDataUtils.binarySearch(new SortableDataList(list, 0), 0);
    }

    public void testBinarySearch() {
        int size = 100;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < 100) {
            list.add(2 * i);
            ++i;
        }
        list.add(44);
        SortableDataUtilsTest.assertEquals((int)22, (int)SortableDataUtils.binarySearch(new SortableDataList(list, 100), 100));
        list.set(100, 45);
        SortableDataUtilsTest.assertEquals((int)23, (int)SortableDataUtils.binarySearch(new SortableDataList(list, 100), 100));
        list.set(100, 32432);
        SortableDataUtilsTest.assertEquals((int)100, (int)SortableDataUtils.binarySearch(new SortableDataList(list, 100), 100));
    }

    private static class SortableDataList<T extends Comparable<T>>
    implements ISortableData {
        private final List<T> list;
        private final int size;

        public SortableDataList(List<T> list, int size) {
            this.list = list;
            this.size = size;
        }

        @Override
        public boolean isLess(int i, int j) {
            return ((Comparable)this.list.get(i)).compareTo((Comparable)this.list.get(j)) < 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void swap(int i, int j) {
            Collections.swap(this.list, i, j);
        }
    }
}

