/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.conqat.lib.commons.collections.CounterSet;

public class SortedCounterSet<E extends Comparable<? super E>>
extends CounterSet<E> {
    private final Comparator<? super E> comparator;

    public SortedCounterSet() {
        this.comparator = null;
    }

    public SortedCounterSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    public int getRangeSum(E firstElement, E lastElement) {
        int lastIndex;
        ArrayList elementList = new ArrayList(this.getKeys());
        if (elementList.isEmpty()) {
            return 0;
        }
        Collections.sort(elementList, this.comparator);
        int firstIndex = Collections.binarySearch(elementList, firstElement, this.comparator);
        if (firstIndex < 0) {
            firstIndex = (firstIndex + 1) * -1;
        }
        if ((lastIndex = Collections.binarySearch(elementList, lastElement, this.comparator)) < 0) {
            lastIndex = (lastIndex + 2) * -1;
        }
        int sum = 0;
        int i = firstIndex;
        while (i <= lastIndex) {
            sum += this.getValue((Comparable)elementList.get(i));
            ++i;
        }
        return sum;
    }
}

