/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class TwoDimHashMap<K1, K2, I> {
    private final Map<K1, Map<K2, I>> main;

    public TwoDimHashMap() {
        this.main = new HashMap<K1, Map<K2, I>>();
    }

    public TwoDimHashMap(Map<K1, Map<K2, I>> outerMap) {
        this.main = outerMap;
    }

    public void putAll(TwoDimHashMap<K1, K2, I> otherMap) {
        for (K1 key1 : otherMap.getFirstKeys()) {
            for (K2 key2 : otherMap.getSecondKeys(key1)) {
                I value = otherMap.getValue(key1, key2);
                this.putValue(key1, key2, value);
            }
        }
    }

    public void putValue(K1 key1, K2 key2, I value) {
        Map<K2, I> map = this.main.get(key1);
        if (map == null) {
            map = new HashMap<K2, I>();
            this.main.put(key1, map);
        }
        map.put(key2, value);
    }

    public I getValue(K1 firstKey, K2 secondKey) {
        Map<K2, I> map = this.main.get(firstKey);
        if (map == null) {
            return null;
        }
        return map.get(secondKey);
    }

    public boolean containsKey(K1 firstKey, K2 secondKey) {
        Map<K2, I> map = this.main.get(firstKey);
        if (map == null) {
            return false;
        }
        return map.containsKey(secondKey);
    }

    public Collection<I> getValuesByFirstKey(K1 firstKey) {
        Map<K2, I> map = this.main.get(firstKey);
        if (map == null) {
            return null;
        }
        return map.values();
    }

    public Set<K1> getFirstKeys() {
        return this.main.keySet();
    }

    public Set<K2> getSecondKeys(K1 firstKey) {
        Map<K2, I> map = this.main.get(firstKey);
        if (map == null) {
            return CollectionUtils.emptySet();
        }
        return map.keySet();
    }

    public List<I> getValuesBySecondKey(K2 secondKey) {
        ArrayList<I> result = new ArrayList<I>();
        for (Map<K2, I> map : this.main.values()) {
            if (!map.containsKey(secondKey)) continue;
            result.add(map.get(secondKey));
        }
        return result;
    }

    public List<I> getValues() {
        ArrayList<I> result = new ArrayList<I>();
        for (Map<K2, I> map : this.main.values()) {
            result.addAll(map.values());
        }
        return result;
    }

    public int getSize() {
        int size = 0;
        for (Map<K2, I> map : this.main.values()) {
            size += map.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSecondSize(K1 key1) {
        Map<K2, I> map = this.main.get(key1);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public void clear() {
        this.main.clear();
    }

    public I remove(K1 key1, K2 key2) {
        Map<K2, I> map = this.main.get(key1);
        if (map == null) {
            return null;
        }
        if (!map.containsKey(key2)) {
            return null;
        }
        I result = map.remove(key2);
        if (map.isEmpty()) {
            this.main.remove(key1);
        }
        return result;
    }

    public boolean remove(K1 key) {
        Map<K2, I> result = this.main.remove(key);
        return result != null;
    }
}

