/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.TwoDimHashMap;

public class TwoDimHashMapTest
extends TestCase {
    private TwoDimHashMap<String, String, String> map;

    protected void setUp() {
        this.map = new TwoDimHashMap();
        this.init(this.map);
    }

    private void init(TwoDimHashMap<String, String, String> map) {
        map.putValue("A", "Dan", "Testing");
        map.putValue("A", "Flo", "Documentation");
        map.putValue("B", "Flo", "Design");
        map.putValue("B", "Dan", "QA");
        map.putValue("B", "Markus", "CM");
    }

    public void testPutAll() {
        TwoDimHashMap<String, String, String> newMap = new TwoDimHashMap<String, String, String>();
        this.init(newMap);
        this.map.clear();
        TwoDimHashMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.putAll(newMap);
        this.testGetValues();
        this.testGetFirstKeys();
        this.testGetSecondKeys();
    }

    public void testPutValue() {
        this.map.putValue("C", "Flo", "Test");
        String result = this.map.getValue("C", "Flo");
        TwoDimHashMapTest.assertEquals((String)"Test", (String)result);
        this.map.putValue("A", "Peter", "Test");
        result = this.map.getValue("A", "Peter");
        TwoDimHashMapTest.assertEquals((String)"Test", (String)result);
        this.map.putValue("A", "Dan", "QA");
        result = this.map.getValue("A", "Dan");
        TwoDimHashMapTest.assertEquals((String)"QA", (String)result);
    }

    public void testGetValue() {
        TwoDimHashMapTest.assertEquals((String)"Testing", (String)this.map.getValue("A", "Dan"));
        TwoDimHashMapTest.assertEquals((String)"Documentation", (String)this.map.getValue("A", "Flo"));
        TwoDimHashMapTest.assertEquals((String)"Design", (String)this.map.getValue("B", "Flo"));
        TwoDimHashMapTest.assertEquals((String)"QA", (String)this.map.getValue("B", "Dan"));
        TwoDimHashMapTest.assertEquals((String)"CM", (String)this.map.getValue("B", "Markus"));
    }

    public void testGetValuesByFirstKey() {
        Collection<String> values = this.map.getValuesByFirstKey("A");
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Testing"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Documentation"));
        TwoDimHashMapTest.assertEquals((int)2, (int)values.size());
        values = this.map.getValuesByFirstKey("B");
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Design"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("QA"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("CM"));
        TwoDimHashMapTest.assertEquals((int)3, (int)values.size());
    }

    public void testGetFirstKeys() {
        Set<String> keys = this.map.getFirstKeys();
        TwoDimHashMapTest.assertTrue((boolean)keys.contains("A"));
        TwoDimHashMapTest.assertTrue((boolean)keys.contains("B"));
        TwoDimHashMapTest.assertEquals((int)2, (int)keys.size());
    }

    public void testGetSecondKeys() {
        Set<String> keys = this.map.getSecondKeys("A");
        TwoDimHashMapTest.assertTrue((boolean)keys.contains("Dan"));
        TwoDimHashMapTest.assertTrue((boolean)keys.contains("Flo"));
        TwoDimHashMapTest.assertEquals((int)2, (int)keys.size());
        keys = this.map.getSecondKeys("B");
        TwoDimHashMapTest.assertTrue((boolean)keys.contains("Dan"));
        TwoDimHashMapTest.assertTrue((boolean)keys.contains("Flo"));
        TwoDimHashMapTest.assertTrue((boolean)keys.contains("Markus"));
        TwoDimHashMapTest.assertEquals((int)3, (int)keys.size());
    }

    public void testGetValuesBySecondKey() {
        List<String> values = this.map.getValuesBySecondKey("Flo");
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Design"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Documentation"));
        TwoDimHashMapTest.assertEquals((int)2, (int)values.size());
        values = this.map.getValuesBySecondKey("Dan");
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Testing"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("QA"));
        TwoDimHashMapTest.assertEquals((int)2, (int)values.size());
        values = this.map.getValuesBySecondKey("Markus");
        TwoDimHashMapTest.assertTrue((boolean)values.contains("CM"));
        TwoDimHashMapTest.assertEquals((int)1, (int)values.size());
    }

    public void testGetValues() {
        List<String> values = this.map.getValues();
        TwoDimHashMapTest.assertEquals((int)5, (int)values.size());
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Testing"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Documentation"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("Design"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("QA"));
        TwoDimHashMapTest.assertTrue((boolean)values.contains("CM"));
    }

    public void testGetSize() {
        TwoDimHashMapTest.assertEquals((int)5, (int)this.map.getSize());
        this.map.putValue("testX", "testY", "testZ");
        TwoDimHashMapTest.assertEquals((int)6, (int)this.map.getSize());
        this.map.remove("testX", "testY");
        TwoDimHashMapTest.assertEquals((int)5, (int)this.map.getSize());
        this.map.remove("A", "Flo");
        TwoDimHashMapTest.assertEquals((int)4, (int)this.map.getSize());
    }

    public void testIsEmpty() {
        TwoDimHashMapTest.assertFalse((boolean)this.map.isEmpty());
        this.map.clear();
        TwoDimHashMapTest.assertTrue((boolean)this.map.isEmpty());
        this.setUp();
        TwoDimHashMapTest.assertFalse((boolean)this.map.isEmpty());
        this.map.remove("A", "Flo");
        this.map.remove("A", "Dan");
        this.map.remove("B", "Flo");
        this.map.remove("B", "Dan");
        this.map.remove("B", "Markus");
        TwoDimHashMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testGetFirstSize() {
        TwoDimHashMapTest.assertEquals((int)2, (int)this.map.getSecondSize("A"));
        TwoDimHashMapTest.assertEquals((int)3, (int)this.map.getSecondSize("B"));
        this.map.putValue("A", "TestX", "TestY");
        TwoDimHashMapTest.assertEquals((int)3, (int)this.map.getSecondSize("A"));
    }

    public void testClear() {
        this.testIsEmpty();
    }

    public void testRemoveSecondLevelKey() {
        this.map.remove("A", "Flo");
        this.map.remove("A", "Dan");
        TwoDimHashMapTest.assertEquals((int)3, (int)this.map.getSize());
        TwoDimHashMapTest.assertNull((Object)this.map.getValue("A", "Flo"));
        TwoDimHashMapTest.assertNull((Object)this.map.getValue("A", "Dan"));
        TwoDimHashMapTest.assertNull(this.map.getValuesByFirstKey("A"));
        this.map.remove("B", "Flo");
        this.map.remove("B", "Dan");
        this.map.remove("B", "Markus");
        TwoDimHashMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testRemoveFirstLevelKey() {
        this.map.remove("A");
        TwoDimHashMapTest.assertEquals((int)3, (int)this.map.getSize());
        TwoDimHashMapTest.assertNull((Object)this.map.getValue("A", "Flo"));
        TwoDimHashMapTest.assertNull((Object)this.map.getValue("A", "Dan"));
        TwoDimHashMapTest.assertNull(this.map.getValuesByFirstKey("A"));
        this.map.remove("B");
        TwoDimHashMapTest.assertTrue((boolean)this.map.isEmpty());
    }
}

