/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import junit.framework.TestCase;
import org.conqat.lib.commons.collections.UniqueIdManager;

public class UniqueIdManagerTest
extends TestCase {
    private final UniqueIdManager<Integer> idManager = new UniqueIdManager();
    private final Integer test1 = new Integer(1);
    private final Integer test2 = new Integer(2);

    public void testObtainId() {
        this.idManager.obtainId(this.test1);
        this.idManager.obtainId(this.test2);
        this.idManager.obtainId(new Integer(3));
        UniqueIdManagerTest.assertEquals((int)0, (int)this.idManager.obtainId(this.test1));
        UniqueIdManagerTest.assertEquals((int)1, (int)this.idManager.obtainId(this.test2));
        UniqueIdManagerTest.assertEquals((int)3, (int)this.idManager.obtainId(new Integer(4)));
    }

    public void testReferenceEqualitySemantics() {
        this.idManager.obtainId(new Integer(3));
        UniqueIdManagerTest.assertFalse((this.idManager.obtainId(new Integer(3)) == 0 ? 1 : 0) != 0);
    }

    public void testClear() {
        this.idManager.obtainId(this.test1);
        UniqueIdManagerTest.assertEquals((int)0, (int)this.idManager.obtainId(this.test1));
        UniqueIdManagerTest.assertEquals((int)1, (int)this.idManager.obtainId(this.test2));
        this.idManager.clear();
        UniqueIdManagerTest.assertEquals((int)0, (int)this.idManager.obtainId(this.test2));
        UniqueIdManagerTest.assertEquals((int)1, (int)this.idManager.obtainId(this.test1));
    }
}

