/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.date;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class DateUtilsTest
extends CCSMTestCaseBase {
    private final Date date1 = new Date(1281102981328L);
    private final Date date2 = new Date(1281102981329L);
    private final Date date3 = new Date(1281102981528L);

    public void testGetEarliest() {
        DateUtilsTest.assertNull((Object)DateUtils.getEarliest(new ArrayList<Date>()));
        DateUtilsTest.assertSame((Object)this.date1, (Object)DateUtils.getEarliest(this.dates()));
        DateUtilsTest.assertSame((Object)this.date1, (Object)DateUtils.getEarliest(CollectionUtils.reverse(this.dates())));
    }

    public void testGetLatest() {
        DateUtilsTest.assertNull((Object)DateUtils.getLatest(new ArrayList<Date>()));
        DateUtilsTest.assertSame((Object)this.date3, (Object)DateUtils.getLatest(this.dates()));
        DateUtilsTest.assertSame((Object)this.date3, (Object)DateUtils.getLatest(CollectionUtils.reverse(this.dates())));
    }

    private List<Date> dates() {
        return Arrays.asList(this.date1, this.date2, this.date3);
    }

    public void testGetMin() {
        DateUtilsTest.assertEquals(null, (Object)DateUtils.min(null, this.date1));
        DateUtilsTest.assertEquals(null, (Object)DateUtils.min(this.date1, null));
        DateUtilsTest.assertEquals(null, (Object)DateUtils.min(null, null));
        DateUtilsTest.assertEquals((Object)this.date1, (Object)DateUtils.min(this.date1, this.date1));
        DateUtilsTest.assertEquals((Object)this.date1, (Object)DateUtils.min(this.date2, this.date1));
        DateUtilsTest.assertEquals((Object)this.date1, (Object)DateUtils.min(this.date1, this.date2));
        DateUtilsTest.assertEquals((Object)this.date1, (Object)DateUtils.min(this.date1, this.date3));
        DateUtilsTest.assertEquals((Object)this.date1, (Object)DateUtils.min(this.date3, this.date1));
    }

    public void testGetMax() {
        DateUtilsTest.assertEquals(null, (Object)DateUtils.max(null, this.date3));
        DateUtilsTest.assertEquals(null, (Object)DateUtils.max(this.date3, null));
        DateUtilsTest.assertEquals(null, (Object)DateUtils.max(null, null));
        DateUtilsTest.assertEquals((Object)this.date3, (Object)DateUtils.min(this.date3, this.date3));
        DateUtilsTest.assertEquals((Object)this.date3, (Object)DateUtils.max(this.date2, this.date3));
        DateUtilsTest.assertEquals((Object)this.date3, (Object)DateUtils.max(this.date3, this.date2));
        DateUtilsTest.assertEquals((Object)this.date3, (Object)DateUtils.max(this.date1, this.date3));
        DateUtilsTest.assertEquals((Object)this.date3, (Object)DateUtils.max(this.date3, this.date1));
    }
}

