/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.digest;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.conqat.lib.commons.digest.Digester;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class DigesterTest
extends CCSMTestCaseBase {
    public void testCreateMD5Digest() {
        String[] bases;
        String[] stringArray = bases = new String[]{"b", "bbb", "Hallo", "This is some Text", "8u6e5783492365"};
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            String base = stringArray[n2];
            String fingerprint = Digester.createMD5Digest(base);
            this.validateFingerprint(fingerprint);
            fingerprint = Digester.createMD5Digest(base.getBytes());
            this.validateFingerprint(fingerprint);
            ++n2;
        }
    }

    private void validateFingerprint(String fingerprint) {
        DigesterTest.assertEquals((int)32, (int)fingerprint.length());
        DigesterTest.assertTrue((String)("Illegal characters found in fingerprint: " + fingerprint), (boolean)Pattern.matches("[0-9a-fA-F]+", fingerprint));
    }

    public void testCreateFingerprintFromCollection() {
        String digest1 = Digester.createMD5Digest(Arrays.asList("a", "b", "c"));
        String digest2 = Digester.createMD5Digest(Arrays.asList("c", "b", "a"));
        DigesterTest.assertEquals((String)digest1, (String)digest2);
    }
}

