/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.PathBasedContentProviderBase;
import org.conqat.lib.commons.string.StringUtils;

final class DirectoryContentProvider
extends PathBasedContentProviderBase {
    private final File baseDir;

    public DirectoryContentProvider(File baseDir) {
        CCSMPre.isTrue(baseDir.isDirectory(), "Input file must be a directory!");
        this.baseDir = baseDir;
    }

    @Override
    public Collection<String> getPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : FileSystemUtils.listFilesRecursively(this.baseDir)) {
            if (!file.isFile()) continue;
            String relative = StringUtils.stripPrefix(this.baseDir.getPath(), file.getPath());
            result.add(StringUtils.stripPrefix("/", FileSystemUtils.normalizeSeparators(relative)));
        }
        return result;
    }

    @Override
    public InputStream openStream(String relativePath) throws IOException {
        return new FileInputStream(new File(this.baseDir, relativePath));
    }

    @Override
    public void close() {
    }
}

