/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.html;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.html.ECSSProperty;

public class CSSDeclarationBlock {
    private final Map<ECSSProperty, String> properties = new EnumMap<ECSSProperty, String>(ECSSProperty.class);
    private final List<CSSDeclarationBlock> inheritsFrom = new ArrayList<CSSDeclarationBlock>();

    public CSSDeclarationBlock(Object ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("Expected even number of arguments");
        }
        int i = 0;
        while (i < values.length) {
            if (!(values[i] instanceof ECSSProperty)) {
                throw new IllegalArgumentException("Expected CSS property as parameter " + i + " instead of " + values[i].getClass());
            }
            if (!(values[i + 1] instanceof String)) {
                throw new IllegalArgumentException("Expected property value (String) as parameter " + (i + 1) + " instead of " + values[i + 1].getClass());
            }
            this.setProperty((ECSSProperty)((Object)values[i]), (String)values[i + 1]);
            i += 2;
        }
    }

    public CSSDeclarationBlock(CSSDeclarationBlock superBlock, Object ... values) {
        this(values);
        this.inheritFrom(superBlock);
    }

    public CSSDeclarationBlock setProperty(ECSSProperty property, String value) {
        this.properties.put(property, value);
        return this;
    }

    private CSSDeclarationBlock setProperties(String value, ECSSProperty ... properties) {
        ECSSProperty[] eCSSPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            ECSSProperty p = eCSSPropertyArray[n2];
            this.setProperty(p, value);
            ++n2;
        }
        return this;
    }

    public CSSDeclarationBlock setMargin(String value) {
        return this.setProperties(value, ECSSProperty.MARGIN_BOTTOM, ECSSProperty.MARGIN_LEFT, ECSSProperty.MARGIN_RIGHT, ECSSProperty.MARGIN_TOP);
    }

    public CSSDeclarationBlock setPadding(String value) {
        return this.setProperties(value, ECSSProperty.PADDING_BOTTOM, ECSSProperty.PADDING_LEFT, ECSSProperty.PADDING_RIGHT, ECSSProperty.PADDING_TOP);
    }

    public CSSDeclarationBlock setBorder(String width, String style, String color) {
        this.setBorderWidth(width);
        this.setBorderStyle(style);
        this.setBorderColor(color);
        return this;
    }

    public CSSDeclarationBlock setBorderWidth(String width) {
        return this.setProperties(width, ECSSProperty.BORDER_BOTTOM_WIDTH, ECSSProperty.BORDER_LEFT_WIDTH, ECSSProperty.BORDER_RIGHT_WIDTH, ECSSProperty.BORDER_TOP_WIDTH);
    }

    public CSSDeclarationBlock setBorderStyle(String style) {
        return this.setProperties(style, ECSSProperty.BORDER_BOTTOM_STYLE, ECSSProperty.BORDER_LEFT_STYLE, ECSSProperty.BORDER_RIGHT_STYLE, ECSSProperty.BORDER_TOP_STYLE);
    }

    public CSSDeclarationBlock setBorderColor(String color) {
        return this.setProperties(color, ECSSProperty.BORDER_BOTTOM_COLOR, ECSSProperty.BORDER_LEFT_COLOR, ECSSProperty.BORDER_RIGHT_COLOR, ECSSProperty.BORDER_TOP_COLOR);
    }

    public CSSDeclarationBlock removeProperty(String property) {
        this.properties.remove(property);
        return this;
    }

    public String getProperty(String property) {
        return this.properties.get(property);
    }

    public CSSDeclarationBlock inheritFrom(CSSDeclarationBlock css) {
        this.inheritsFrom.add(css);
        return this;
    }

    private void fillFullPropertyMap(Map<ECSSProperty, String> map) {
        for (CSSDeclarationBlock block : this.inheritsFrom) {
            block.fillFullPropertyMap(map);
        }
        map.putAll(this.properties);
    }

    public void writeOut(PrintStream ps, String indent) {
        EnumMap<ECSSProperty, String> result = new EnumMap<ECSSProperty, String>(ECSSProperty.class);
        this.fillFullPropertyMap(result);
        for (ECSSProperty property : result.keySet()) {
            ps.println(String.valueOf(indent) + property.getName() + ": " + (String)result.get((Object)property) + ";");
        }
    }

    public String toInlineStyle() {
        StringBuilder sb = new StringBuilder();
        EnumMap<ECSSProperty, String> result = new EnumMap<ECSSProperty, String>(ECSSProperty.class);
        this.fillFullPropertyMap(result);
        for (ECSSProperty property : result.keySet()) {
            sb.append(String.valueOf(property.getName()) + ": " + (String)result.get((Object)property) + "; ");
        }
        return sb.toString();
    }
}

