/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class GraphicsUtils {
    public static GeneralPath getArrowHead(Point p1, Point p2, int arrowBarbSize, double arrowPhi) {
        double theta = Math.atan2(p2.y - p1.y, p2.x - p1.x);
        GeneralPath path = new GeneralPath();
        double x = (double)p2.x + (double)arrowBarbSize * Math.cos(theta + Math.PI - arrowPhi);
        double y = (double)p2.y + (double)arrowBarbSize * Math.sin(theta + Math.PI - arrowPhi);
        path.moveTo((float)x, (float)y);
        path.lineTo(p2.x, p2.y);
        x = (double)p2.x + (double)arrowBarbSize * Math.cos(theta + Math.PI + arrowPhi);
        y = (double)p2.y + (double)arrowBarbSize * Math.sin(theta + Math.PI + arrowPhi);
        path.lineTo((float)x, (float)y);
        return path;
    }

    public static Point getChopboxAnchor(Rectangle box, Point referencePoint) {
        double baseX = box.getCenterX();
        double baseY = box.getCenterY();
        double refX = referencePoint.x;
        double refY = referencePoint.y;
        if (box.isEmpty() || refX == baseX && refY == baseY) {
            return new Point((int)refX, (int)refY);
        }
        double dx = refX - baseX;
        double dy = refY - baseY;
        double scale = 0.5 / Math.max(Math.abs(dx) / (double)box.width, Math.abs(dy) / (double)box.height);
        return new Point((int)Math.round(baseX += dx * scale), (int)Math.round(baseY += dy * scale));
    }
}

