/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import junit.framework.TestCase;
import org.conqat.lib.commons.options.CommandLine;
import org.conqat.lib.commons.options.OptionException;
import org.conqat.lib.commons.options.OptionRegistry;
import org.conqat.lib.commons.options.SimpleOptionHandler;

public class CommandLineTest
extends TestCase {
    private SimpleOptionHandler soh;
    private CommandLine cl;

    public void setUp() {
        this.soh = new SimpleOptionHandler();
        OptionRegistry r = new OptionRegistry(this.soh);
        this.cl = new CommandLine(r);
    }

    public void testUsage() {
        this.cl.printUsage(new PrintWriter(new OutputStreamWriter(System.out)));
    }

    public void testSimpleOptions() throws Exception {
        String[] args = new String[]{"-i", "--store", "42"};
        CommandLineTest.assertEquals((int)0, (int)this.cl.parse(args).length);
        CommandLineTest.assertEquals((int)1, (int)this.soh.counter);
        CommandLineTest.assertTrue((Math.abs(42.0 - this.soh.storedDouble) < 1.0E-6 ? 1 : 0) != 0);
    }

    public void testComplexOptions() throws Exception {
        String[] args = new String[]{"-iiiis", "42", "foo", "bar"};
        CommandLineTest.assertEquals((int)2, (int)this.cl.parse(args).length);
        CommandLineTest.assertEquals((int)4, (int)this.soh.counter);
        CommandLineTest.assertTrue((Math.abs(42.0 - this.soh.storedDouble) < 1.0E-6 ? 1 : 0) != 0);
    }

    public void testEqualArg() throws Exception {
        String[] args = new String[]{"-i", "--store=42"};
        CommandLineTest.assertEquals((int)0, (int)this.cl.parse(args).length);
        CommandLineTest.assertTrue((Math.abs(42.0 - this.soh.storedDouble) < 1.0E-6 ? 1 : 0) != 0);
    }

    public void testMissingArgument() {
        boolean ok = false;
        String[] args = new String[]{"-i", "--store"};
        try {
            this.cl.parse(args);
        }
        catch (OptionException e) {
            ok = true;
        }
        CommandLineTest.assertTrue((boolean)ok);
    }

    public void testMissingArgumentInMulti() {
        boolean ok = false;
        String[] args = new String[]{"-iiisi", "42"};
        try {
            this.cl.parse(args);
        }
        catch (OptionException e) {
            ok = true;
        }
        CommandLineTest.assertTrue((boolean)ok);
    }

    public void testWrongType() {
        boolean ok = false;
        String[] args = new String[]{"-s", "noNumber"};
        try {
            this.cl.parse(args);
        }
        catch (OptionException e) {
            ok = true;
        }
        CommandLineTest.assertTrue((boolean)ok);
    }

    public void testSuperfluousArgument() {
        boolean ok = false;
        String[] args = new String[]{"--inc=fail"};
        try {
            CommandLineTest.assertEquals((int)0, (int)this.cl.parse(args).length);
        }
        catch (OptionException e) {
            ok = true;
        }
        CommandLineTest.assertTrue((boolean)ok);
    }

    public void testGreedyOption() throws OptionException {
        String[] args = new String[]{"--greedy", "4", "3", "7", "-g", "9", "23", "54", "--inc", "test"};
        CommandLineTest.assertEquals((int)1, (int)this.cl.parse(args).length);
        CommandLineTest.assertEquals((int)101, (int)this.soh.counter);
    }
}

