/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.util.LinkedList;
import java.util.Queue;

public class CommandLineTokenStream {
    private final Queue<Character> shortOptionQueue = new LinkedList<Character>();
    private String pendingParam = null;
    private final Queue<String> argQueue = new LinkedList<String>();

    public CommandLineTokenStream(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            this.argQueue.add(a);
            ++n2;
        }
    }

    public boolean hasNext() {
        return !this.argQueue.isEmpty() || !this.shortOptionQueue.isEmpty() || this.pendingParam != null;
    }

    public boolean nextIsShortOption() {
        if (!this.shortOptionQueue.isEmpty()) {
            return true;
        }
        if (this.pendingParam != null || this.argQueue.isEmpty()) {
            return false;
        }
        String next = this.argQueue.peek();
        return next.length() >= 2 && next.charAt(0) == '-' && next.charAt(1) != '-';
    }

    public boolean nextIsLongOption() {
        if (!this.shortOptionQueue.isEmpty() || this.pendingParam != null || this.argQueue.isEmpty()) {
            return false;
        }
        return this.argQueue.peek().startsWith("--");
    }

    public boolean nextIsFileArgument() {
        if (!this.shortOptionQueue.isEmpty() || this.pendingParam != null || this.argQueue.isEmpty()) {
            return false;
        }
        return !this.argQueue.peek().startsWith("-");
    }

    public boolean nextIsParameter() {
        if (!this.shortOptionQueue.isEmpty()) {
            return false;
        }
        if (this.pendingParam != null) {
            return true;
        }
        return !this.argQueue.isEmpty();
    }

    public String next() {
        if (!this.shortOptionQueue.isEmpty()) {
            return "-" + this.shortOptionQueue.poll();
        }
        if (this.pendingParam != null) {
            String result = this.pendingParam;
            this.pendingParam = null;
            return result;
        }
        return this.argQueue.poll();
    }

    public char nextShortOption() {
        if (!this.nextIsShortOption()) {
            throw new IllegalStateException("No short option available!");
        }
        if (this.shortOptionQueue.isEmpty()) {
            String arg = this.argQueue.poll();
            int i = 1;
            while (i < arg.length()) {
                this.shortOptionQueue.add(Character.valueOf(arg.charAt(i)));
                ++i;
            }
        }
        return this.shortOptionQueue.poll().charValue();
    }

    public String nextLongOption() {
        if (!this.nextIsLongOption()) {
            throw new IllegalStateException("No long option available!");
        }
        String res = this.argQueue.poll().substring(2);
        if (res.contains("=")) {
            String[] parts = res.split("=", 2);
            res = parts[0];
            this.pendingParam = parts[1];
        }
        return res;
    }
}

