/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.options.AOption;
import org.conqat.lib.commons.options.OptionApplicator;

public class OptionRegistry {
    private final Map<Character, OptionApplicator> shortOptions = new HashMap<Character, OptionApplicator>();
    private final Map<String, OptionApplicator> longOptions = new HashMap<String, OptionApplicator>();
    private final List<AOption> allOptions = new ArrayList<AOption>();

    public OptionRegistry() {
    }

    public OptionRegistry(Object optionHandler) {
        this.registerOptionHandler(optionHandler);
    }

    public void registerOptionHandler(Object optionHandler) {
        Method[] methodArray = optionHandler.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            AOption optionDescriptor = m.getAnnotation(AOption.class);
            if (optionDescriptor != null) {
                this.allOptions.add(optionDescriptor);
                OptionApplicator applicator = new OptionApplicator(optionHandler, m, optionDescriptor.greedy());
                if (optionDescriptor.shortName() != '\u0000') {
                    this.registerApplicator(applicator, this.shortOptions, Character.valueOf(optionDescriptor.shortName()));
                }
                if (optionDescriptor.longName().length() > 0) {
                    this.registerApplicator(applicator, this.longOptions, optionDescriptor.longName());
                }
            }
            ++n2;
        }
    }

    private <T> void registerApplicator(OptionApplicator applicator, Map<T, OptionApplicator> map, T optionName) {
        if (map.containsKey(optionName)) {
            throw new IllegalArgumentException("An option of the name " + optionName + " already exists!");
        }
        map.put(optionName, applicator);
    }

    public OptionApplicator getShortOption(char name) {
        return this.shortOptions.get(Character.valueOf(name));
    }

    public OptionApplicator getLongOption(String name) {
        return this.longOptions.get(name);
    }

    public List<AOption> getAllOptions() {
        return this.allOptions;
    }
}

