/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.reflect.ClassType;
import org.conqat.lib.commons.reflect.TypesNotMergableException;

public class ClassTypeTest
extends TestCase {
    public void testBaseClass() throws TypesNotMergableException {
        ClassTypeTest.assertEquals(Object.class, new ClassType().getBaseClass());
        ClassTypeTest.assertEquals(Integer.class, new ClassType((Class<?>)Integer.class).getBaseClass());
        ClassTypeTest.assertEquals(Integer.class, new ClassType((Class<?>)Integer.TYPE).getBaseClass());
        ClassTypeTest.assertEquals(Integer.class, new ClassType(Integer.class, Serializable.class).getBaseClass());
        ClassTypeTest.assertEquals(Integer.class, new ClassType(Integer.class, Number.class).getBaseClass());
    }

    public void testInterfaces() throws TypesNotMergableException {
        this.checkInterfaces(new ClassType(), new Class[0]);
        this.checkInterfaces(new ClassType((Class<?>)Integer.class), new Class[0]);
        this.checkInterfaces(new ClassType((Class<?>)Serializable.class), Serializable.class);
        this.checkInterfaces(new ClassType(Serializable.class, Integer.class), new Class[0]);
        this.checkInterfaces(new ClassType(List.class, Collection.class, Iterable.class), List.class);
        this.checkInterfaces(new ClassType(List.class, Collection.class, ArrayList.class, Iterable.class), new Class[0]);
        this.checkInterfaces(new ClassType(Map.class, List.class, Serializable.class, Collection.class, Iterable.class, SortedMap.class), List.class, Serializable.class, SortedMap.class);
    }

    public void testMerge() throws TypesNotMergableException {
        ClassType ct1 = new ClassType(Writer.class, List.class);
        ClassType ct2 = new ClassType(PrintWriter.class, Collection.class);
        ClassTypeTest.assertEquals((Object)new ClassType(PrintWriter.class, List.class), (Object)ct1.merge(ct2));
        ClassTypeTest.assertEquals((Object)new ClassType(PrintWriter.class, List.class), (Object)ct2.merge(ct1));
        try {
            new ClassType((Class<?>)Integer.class).merge(new ClassType((Class<?>)String.class));
            ClassTypeTest.assertTrue((String)"Expected exception!", (boolean)false);
        }
        catch (TypesNotMergableException typesNotMergableException) {
            // empty catch block
        }
    }

    public void testAssignability() throws TypesNotMergableException {
        ClassTypeTest.assertTrue((boolean)new ClassType((Class<?>)Number.class).isAssignableFrom(new ClassType((Class<?>)Integer.class)));
        ClassTypeTest.assertFalse((boolean)new ClassType((Class<?>)Integer.class).isAssignableFrom(new ClassType((Class<?>)Number.class)));
        ClassTypeTest.assertTrue((boolean)new ClassType((Class<?>)Number.class).isAssignableFrom(new ClassType(Integer.class, List.class)));
        ClassTypeTest.assertFalse((boolean)new ClassType(Number.class, List.class).isAssignableFrom(new ClassType((Class<?>)Integer.class)));
        ClassTypeTest.assertTrue((boolean)new ClassType(Number.class, Collection.class).isAssignableFrom(new ClassType(Integer.class, List.class)));
        ClassTypeTest.assertTrue((boolean)new ClassType(Iterable.class, Collection.class).isAssignableFrom(new ClassType(Integer.class, List.class)));
        ClassTypeTest.assertTrue((boolean)new ClassType(Iterable.class, Collection.class).isAssignableFrom(new ClassType((Class<?>)ArrayList.class)));
        ClassTypeTest.assertFalse((boolean)new ClassType((Class<?>)List.class).isAssignableFrom(new ClassType(Iterable.class, Collection.class)));
    }

    private void checkInterfaces(ClassType classType, Class<?> ... expectedInterfaces) {
        UnmodifiableSet<Class<?>> observedInterfaces = classType.getInterfaces();
        ClassTypeTest.assertEquals((int)expectedInterfaces.length, (int)observedInterfaces.size());
        Class<?>[] classArray = expectedInterfaces;
        int n = expectedInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            ClassTypeTest.assertTrue((String)("Should include " + c.getName()), (boolean)observedInterfaces.contains(c));
            ++n2;
        }
    }
}

