/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.conqat.lib.commons.reflect.ATestParameterAnnotation1;
import org.conqat.lib.commons.reflect.ATestParameterAnnotation2;
import org.conqat.lib.commons.reflect.FormalParameter;
import org.conqat.lib.commons.reflect.TestClass;
import org.conqat.lib.commons.string.StringUtils;

public class FormalParameterTest
extends TestCase {
    private FormalParameter referenceTypeParameter;
    private FormalParameter primitiveTypeParameter;
    private FormalParameter referenceArrayTypeParameter;
    private FormalParameter primitiveArrayTypeParameter;
    private FormalParameter annotatedParameter;

    protected void setUp() throws Exception {
        super.setUp();
        Class[] parameters0 = new Class[]{String.class};
        Method method0 = String.class.getMethod("compareTo", parameters0);
        this.referenceTypeParameter = new FormalParameter(method0, 0);
        Class[] parameters1 = new Class[]{Integer.TYPE};
        Method method1 = String.class.getMethod("charAt", parameters1);
        this.primitiveTypeParameter = new FormalParameter(method1, 0);
        Class[] parameters2 = new Class[]{char[].class, Integer.TYPE, Integer.TYPE};
        Method method2 = String.class.getMethod("copyValueOf", parameters2);
        this.primitiveArrayTypeParameter = new FormalParameter(method2, 0);
        Class[] parameters3 = new Class[]{String[].class, String[].class};
        Method method3 = StringUtils.class.getMethod("concat", parameters3);
        this.referenceArrayTypeParameter = new FormalParameter(method3, 1);
        Class[] parameters4 = new Class[]{String.class};
        Method method4 = TestClass.class.getMethod("testMethod", parameters4);
        this.annotatedParameter = new FormalParameter(method4, 0);
    }

    public void testGetType() {
        FormalParameterTest.assertEquals(String.class, this.referenceTypeParameter.getType());
        FormalParameterTest.assertEquals(Integer.TYPE, this.primitiveTypeParameter.getType());
        FormalParameterTest.assertEquals(String[].class, this.referenceArrayTypeParameter.getType());
        FormalParameterTest.assertEquals(char[].class, this.primitiveArrayTypeParameter.getType());
        FormalParameterTest.assertEquals(String.class, this.annotatedParameter.getType());
    }

    public void testGetAnnotations() {
        FormalParameterTest.assertEquals((int)0, (int)this.referenceTypeParameter.getAnnotations().length);
        Annotation[] annotations = this.annotatedParameter.getAnnotations();
        FormalParameterTest.assertEquals((int)2, (int)annotations.length);
        FormalParameterTest.assertEquals(ATestParameterAnnotation1.class, annotations[0].annotationType());
        FormalParameterTest.assertEquals(ATestParameterAnnotation2.class, annotations[1].annotationType());
    }

    public void testGetAnnotation() {
        ATestParameterAnnotation1 annotation1 = this.annotatedParameter.getAnnotation(ATestParameterAnnotation1.class);
        FormalParameterTest.assertNotNull((Object)annotation1);
        FormalParameterTest.assertEquals(ATestParameterAnnotation1.class, annotation1.annotationType());
        ATestParameterAnnotation2 annotation2 = this.annotatedParameter.getAnnotation(ATestParameterAnnotation2.class);
        FormalParameterTest.assertNotNull((Object)annotation2);
        FormalParameterTest.assertEquals(ATestParameterAnnotation2.class, annotation2.annotationType());
        SuppressWarnings annotation = this.annotatedParameter.getAnnotation(SuppressWarnings.class);
        FormalParameterTest.assertNull((Object)annotation);
    }

    public void testIsAnnotationPresent() {
        FormalParameterTest.assertTrue((boolean)this.annotatedParameter.isAnnotationPresent(ATestParameterAnnotation1.class));
        FormalParameterTest.assertTrue((boolean)this.annotatedParameter.isAnnotationPresent(ATestParameterAnnotation2.class));
        FormalParameterTest.assertFalse((boolean)this.annotatedParameter.isAnnotationPresent(SuppressWarnings.class));
    }

    public void testHashCode() throws SecurityException, NoSuchMethodException {
        Class[] parameters0 = new Class[]{String.class};
        Method method0 = String.class.getMethod("compareTo", parameters0);
        FormalParameter parameter = new FormalParameter(method0, 0);
        FormalParameterTest.assertEquals((int)parameter.hashCode(), (int)this.referenceTypeParameter.hashCode());
    }

    public void testEqualsObject() throws SecurityException, NoSuchMethodException {
        FormalParameterTest.assertFalse((boolean)this.primitiveTypeParameter.equals(this.referenceTypeParameter));
        Class[] parameters0 = new Class[]{String.class};
        Method method0 = String.class.getMethod("compareTo", parameters0);
        FormalParameter parameter = new FormalParameter(method0, 0);
        FormalParameterTest.assertEquals((Object)parameter, (Object)this.referenceTypeParameter);
    }
}

