/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.conqat.lib.commons.reflect.FormalParameter;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.reflect.TypeConversionException;

public class ReflectionUtilsTest
extends TestCase {
    public void testGetFormalParameters() throws SecurityException, NoSuchMethodException {
        Class[] parameterTypes0 = new Class[]{String.class};
        this.check(String.class, "compareTo", parameterTypes0);
        Class[] parameterTypes1 = new Class[]{Locale.class, String.class, Object[].class};
        this.check(String.class, "format", parameterTypes1);
        Class[] parameterTypes2 = new Class[]{};
        this.check(String.class, "trim", parameterTypes2);
        Class[] parameterTypes3 = new Class[]{char[].class, Integer.TYPE, Integer.TYPE};
        this.check(String.class, "copyValueOf", parameterTypes3);
    }

    private void check(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws SecurityException, NoSuchMethodException {
        Method method = clazz.getMethod(methodName, parameterTypes);
        FormalParameter[] parameters = ReflectionUtils.getFormalParameters(method);
        ReflectionUtilsTest.assertEquals((int)parameterTypes.length, (int)parameters.length);
        int i = 0;
        while (i < parameterTypes.length) {
            ReflectionUtilsTest.assertEquals(parameterTypes[i], parameters[i].getType());
            ++i;
        }
    }

    public void testInvokeOneParameter() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String testString = "test";
        Class[] parameterTypes0 = new Class[]{String.class};
        Method method = String.class.getMethod("matches", parameterTypes0);
        FormalParameter[] formalParameters = ReflectionUtils.getFormalParameters(method);
        HashMap<FormalParameter, Object> parameters = new HashMap<FormalParameter, Object>();
        parameters.put(formalParameters[0], "test");
        ReflectionUtilsTest.assertTrue((boolean)((Boolean)ReflectionUtils.invoke(method, testString, parameters)));
        parameters.put(formalParameters[0], "x");
        ReflectionUtilsTest.assertFalse((boolean)((Boolean)ReflectionUtils.invoke(method, testString, parameters)));
    }

    public void testResolveType() throws ClassNotFoundException {
        ReflectionUtilsTest.assertEquals(String.class, ReflectionUtils.resolveType("java.lang.String"));
        ReflectionUtilsTest.assertEquals(Boolean.class, ReflectionUtils.resolveType("java.lang.Boolean"));
        ReflectionUtilsTest.assertEquals(Byte.TYPE, ReflectionUtils.resolveType("byte"));
        ReflectionUtilsTest.assertEquals(Character.TYPE, ReflectionUtils.resolveType("char"));
        ReflectionUtilsTest.assertEquals(Double.TYPE, ReflectionUtils.resolveType("double"));
        ReflectionUtilsTest.assertEquals(Float.TYPE, ReflectionUtils.resolveType("float"));
        ReflectionUtilsTest.assertEquals(Integer.TYPE, ReflectionUtils.resolveType("int"));
        ReflectionUtilsTest.assertEquals(Long.TYPE, ReflectionUtils.resolveType("long"));
        ReflectionUtilsTest.assertEquals(Short.TYPE, ReflectionUtils.resolveType("short"));
        ReflectionUtilsTest.assertEquals(Boolean.TYPE, ReflectionUtils.resolveType("boolean"));
    }

    public void testInvokeOnePrimitiveParameter() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String testString = "test";
        Class[] parameterTypes0 = new Class[]{Integer.TYPE};
        Method method = String.class.getMethod("charAt", parameterTypes0);
        FormalParameter[] formalParameters = ReflectionUtils.getFormalParameters(method);
        HashMap<FormalParameter, Object> parameters = new HashMap<FormalParameter, Object>();
        parameters.put(formalParameters[0], 1);
        ReflectionUtilsTest.assertEquals((Object)Character.valueOf('e'), (Object)ReflectionUtils.invoke(method, testString, parameters));
    }

    public void testInvokeTwoParameters() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String testString = "test";
        Class[] parameterTypes0 = new Class[]{String.class, String.class};
        Method method = String.class.getMethod("replaceAll", parameterTypes0);
        FormalParameter[] formalParameters = ReflectionUtils.getFormalParameters(method);
        HashMap<FormalParameter, Object> parameters = new HashMap<FormalParameter, Object>();
        parameters.put(formalParameters[0], "t");
        parameters.put(formalParameters[1], "x");
        ReflectionUtilsTest.assertEquals((Object)"xesx", (Object)ReflectionUtils.invoke(method, testString, parameters));
    }

    public void testInvokeTwoIllegal() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String testString = "test";
        Class[] parameterTypes0 = new Class[]{Integer.TYPE};
        Method method0 = String.class.getMethod("charAt", parameterTypes0);
        FormalParameter[] formalParameters0 = ReflectionUtils.getFormalParameters(method0);
        Class[] parameterTypes1 = new Class[]{String.class};
        Method method1 = String.class.getMethod("matches", parameterTypes1);
        FormalParameter[] formalParameters1 = ReflectionUtils.getFormalParameters(method1);
        HashMap<FormalParameter, Object> parameters = new HashMap<FormalParameter, Object>();
        parameters.put(formalParameters0[0], "t");
        parameters.put(formalParameters1[0], "x");
        try {
            ReflectionUtils.invoke(method0, testString, parameters);
            ReflectionUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsAssignable() {
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(String.class, Object.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Object.class, Object.class));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isAssignable(Object.class, String.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Character.class, Character.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Character.TYPE, Character.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Character.TYPE, Character.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Character.class, Character.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Byte.class, Byte.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Byte.TYPE, Byte.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Byte.TYPE, Byte.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Byte.class, Byte.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Short.class, Short.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Short.TYPE, Short.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Short.TYPE, Short.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Short.class, Short.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Integer.class, Integer.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Integer.TYPE, Integer.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Integer.TYPE, Integer.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Integer.class, Integer.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Long.class, Long.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Long.TYPE, Long.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Long.TYPE, Long.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Long.class, Long.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Float.class, Float.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Float.TYPE, Float.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Float.TYPE, Float.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Float.class, Float.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Double.class, Double.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Double.TYPE, Double.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Double.TYPE, Double.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Double.class, Double.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Boolean.class, Boolean.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Boolean.TYPE, Boolean.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Boolean.TYPE, Boolean.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignable(Boolean.class, Boolean.class));
    }

    public void testConvertPrimitiveForNonPrimitive() throws TypeConversionException {
        try {
            ReflectionUtils.convertPrimitive("test", Object.class);
            ReflectionUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConvertPrimitive() throws TypeConversionException {
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.convertPrimitive("1", Boolean.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.convertPrimitive("yes", Boolean.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.convertPrimitive("on", Boolean.TYPE));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.convertPrimitive("true", Boolean.TYPE));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.convertPrimitive("x", Boolean.TYPE));
        ReflectionUtilsTest.assertEquals((Object)Character.valueOf('t'), (Object)ReflectionUtils.convertPrimitive("test", Character.TYPE));
        ReflectionUtilsTest.assertEquals((Object)123, (Object)ReflectionUtils.convertPrimitive("123", Byte.TYPE));
        ReflectionUtilsTest.assertEquals((Object)123, (Object)ReflectionUtils.convertPrimitive("123", Short.TYPE));
        ReflectionUtilsTest.assertEquals((Object)123, (Object)ReflectionUtils.convertPrimitive("123", Integer.TYPE));
        ReflectionUtilsTest.assertEquals((Object)123L, (Object)ReflectionUtils.convertPrimitive("123", Long.TYPE));
        ReflectionUtilsTest.assertEquals((Object)Float.valueOf(123.0f), (Object)ReflectionUtils.convertPrimitive("123", Float.TYPE));
        ReflectionUtilsTest.assertEquals((Object)123.0, (Object)ReflectionUtils.convertPrimitive("123", Double.TYPE));
    }

    public void testNumberConversionErrors() {
        try {
            ReflectionUtils.convertPrimitive("abc", Integer.TYPE);
            ReflectionUtilsTest.fail();
        }
        catch (TypeConversionException e) {
            ReflectionUtilsTest.assertTrue((boolean)(e.getCause() instanceof NumberFormatException));
        }
    }

    public void testConvertString() throws TypeConversionException {
        ReflectionUtilsTest.assertEquals((String)"", (String)ReflectionUtils.convertString(null, String.class));
        ReflectionUtilsTest.assertEquals((String)"hallo", (String)ReflectionUtils.convertString("hallo", String.class));
        ReflectionUtilsTest.assertEquals((Object)123, (Object)ReflectionUtils.convertString("123", Integer.TYPE));
        ReflectionUtilsTest.assertEquals((Object)((Object)TestEnum.ALPHA), (Object)((Object)ReflectionUtils.convertString("alpha", TestEnum.class)));
        ReflectionUtilsTest.assertEquals((Object)123, (Object)ReflectionUtils.convertString("123", Integer.class));
        ReflectionUtilsTest.assertEquals((Object)new File("test"), (Object)ReflectionUtils.convertString("test", File.class));
    }

    public void testConvertStringToObject() throws Exception {
        ReflectionUtilsTest.assertEquals((Object)"o", (Object)ReflectionUtils.convertString("o", Object.class));
    }

    public void testConvertStringExceptions() {
        this.checkException(null, Integer.TYPE);
        this.checkException("", Integer.TYPE);
        this.checkException("abc", Integer.TYPE);
        this.checkException("abc", Integer.class);
        this.checkException("abc", TestEnum.class);
        this.checkException("abc", Class.class);
    }

    public void testGetSuperClasses() {
        List<Class<?>> superClasses = ReflectionUtils.getSuperClasses(Object.class);
        ReflectionUtilsTest.assertTrue((boolean)superClasses.isEmpty());
        superClasses = ReflectionUtils.getSuperClasses(String.class);
        this.assertEqualLists(superClasses, Object.class);
        superClasses = ReflectionUtils.getSuperClasses(ArrayList.class);
        this.assertEqualLists(superClasses, AbstractList.class, AbstractCollection.class, Object.class);
        superClasses = ReflectionUtils.getSuperClasses(new String[0].getClass());
        this.assertEqualLists(superClasses, Object.class);
        superClasses = ReflectionUtils.getSuperClasses(Integer.TYPE);
        ReflectionUtilsTest.assertTrue((boolean)superClasses.isEmpty());
        superClasses = ReflectionUtils.getSuperClasses(Map.class);
        ReflectionUtilsTest.assertTrue((boolean)superClasses.isEmpty());
        superClasses = ReflectionUtils.getSuperClasses(TestEnum.class);
        this.assertEqualLists(superClasses, Enum.class, Object.class);
    }

    public void testPerformNearestClassLookup() {
        HashMap<Class, Class> m = new HashMap<Class, Class>();
        ReflectionUtilsTest.assertNull(ReflectionUtils.performNearestClassLookup(String.class, m));
        m.put(Object.class, Object.class);
        ReflectionUtilsTest.assertSame(Object.class, ReflectionUtils.performNearestClassLookup(String.class, m));
        m.put(String.class, String.class);
        ReflectionUtilsTest.assertSame(String.class, ReflectionUtils.performNearestClassLookup(String.class, m));
        ReflectionUtilsTest.assertSame(Object.class, ReflectionUtils.performNearestClassLookup(ArrayList.class, m));
        m.put(Iterable.class, Iterable.class);
        ReflectionUtilsTest.assertSame(Iterable.class, ReflectionUtils.performNearestClassLookup(ArrayList.class, m));
        m.put(List.class, List.class);
        ReflectionUtilsTest.assertSame(List.class, ReflectionUtils.performNearestClassLookup(ArrayList.class, m));
        m.put(AbstractList.class, AbstractList.class);
        ReflectionUtilsTest.assertSame(AbstractList.class, ReflectionUtils.performNearestClassLookup(ArrayList.class, m));
        m.put(ArrayList.class, ArrayList.class);
        ReflectionUtilsTest.assertSame(ArrayList.class, ReflectionUtils.performNearestClassLookup(ArrayList.class, m));
    }

    private void assertEqualLists(List<Class<?>> superClasses, Class<?> ... classes) {
        ReflectionUtilsTest.assertEquals((int)classes.length, (int)superClasses.size());
        int i = 0;
        while (i < classes.length) {
            ReflectionUtilsTest.assertEquals(classes[i], superClasses.get(i));
            ++i;
        }
    }

    private void checkException(String value, Class<?> targetType) {
        try {
            ReflectionUtils.convertString(value, targetType);
            ReflectionUtilsTest.fail();
        }
        catch (TypeConversionException typeConversionException) {
            // empty catch block
        }
    }

    public void testListInstancesOf() {
        ArrayList<Object> input = new ArrayList<Object>();
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.listInstances(input, Object.class).isEmpty());
        Object o1 = new Object();
        input.add(o1);
        List<Object> filtered1 = ReflectionUtils.listInstances(input, Object.class);
        ReflectionUtilsTest.assertEquals((int)1, (int)filtered1.size());
        ReflectionUtilsTest.assertSame((Object)o1, (Object)filtered1.get(0));
        String s1 = "some string";
        input.add(s1);
        List<Object> objectList = ReflectionUtils.listInstances(input, Object.class);
        ReflectionUtilsTest.assertEquals((int)2, (int)objectList.size());
        ReflectionUtilsTest.assertSame((Object)o1, (Object)objectList.get(0));
        ReflectionUtilsTest.assertSame((Object)s1, (Object)objectList.get(1));
        List<String> stringList = ReflectionUtils.listInstances(input, String.class);
        ReflectionUtilsTest.assertEquals((int)1, (int)stringList.size());
        ReflectionUtilsTest.assertSame((Object)s1, (Object)stringList.get(0));
    }

    private static enum TestEnum {
        ALPHA;

    }
}

