/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.region;

import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class RegionSetTest
extends CCSMTestCaseBase {
    private int countRegions(RegionSet regions) {
        int count = 0;
        for (Region region : regions) {
            RegionSetTest.assertNotNull((Object)region);
            ++count;
        }
        return count;
    }

    public void testContainsOnSetWithSingleRegion() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(15, 20));
        RegionSetTest.assertTrue((boolean)regions.contains(15));
        RegionSetTest.assertTrue((boolean)regions.contains(16));
        RegionSetTest.assertTrue((boolean)regions.contains(20));
        RegionSetTest.assertFalse((boolean)regions.contains(14));
        RegionSetTest.assertFalse((boolean)regions.contains(21));
    }

    public void testContainsOnSetWithMultipleRegions() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(15, 20), RegionSetTest.r(14, 17), RegionSetTest.r(25, 30));
        RegionSetTest.assertTrue((boolean)regions.contains(14));
        RegionSetTest.assertTrue((boolean)regions.contains(15));
        RegionSetTest.assertTrue((boolean)regions.contains(16));
        RegionSetTest.assertTrue((boolean)regions.contains(20));
        RegionSetTest.assertFalse((boolean)regions.contains(13));
        RegionSetTest.assertFalse((boolean)regions.contains(21));
        RegionSetTest.assertFalse((boolean)regions.contains(24));
        RegionSetTest.assertFalse((boolean)regions.contains(31));
    }

    public void testContainsAny() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(15, 20), RegionSetTest.r(14, 17), RegionSetTest.r(25, 30));
        RegionSetTest.assertFalse((boolean)regions.containsAny(RegionSetTest.r(0, 13)));
        RegionSetTest.assertFalse((boolean)regions.containsAny(RegionSetTest.r(21, 24)));
        RegionSetTest.assertFalse((boolean)regions.containsAny(RegionSetTest.r(31, 34)));
        RegionSetTest.assertTrue((boolean)regions.containsAny(RegionSetTest.r(14, 15)));
        RegionSetTest.assertTrue((boolean)regions.containsAny(RegionSetTest.r(15, 15)));
        RegionSetTest.assertTrue((boolean)regions.containsAny(RegionSetTest.r(20, 20)));
        RegionSetTest.assertTrue((boolean)regions.containsAny(RegionSetTest.r(18, 20)));
        RegionSetTest.assertTrue((boolean)regions.containsAny(RegionSetTest.r(16, 17)));
        RegionSetTest.assertTrue((boolean)regions.containsAny(RegionSetTest.r(20, 28)));
        RegionSetTest.assertTrue((boolean)regions.containsAny(RegionSetTest.r(24, 32)));
    }

    public void testContains() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(15, 20), RegionSetTest.r(14, 17), RegionSetTest.r(25, 30));
        RegionSetTest.assertTrue((boolean)regions.contains(RegionSetTest.r(15, 20)));
        RegionSetTest.assertTrue((boolean)regions.contains(RegionSetTest.r(16, 19)));
        RegionSetTest.assertTrue((boolean)regions.contains(RegionSetTest.r(15, 16)));
        RegionSetTest.assertFalse((boolean)regions.contains(RegionSetTest.r(0, 13)));
        RegionSetTest.assertFalse((boolean)regions.contains(RegionSetTest.r(21, 24)));
        RegionSetTest.assertFalse((boolean)regions.contains(RegionSetTest.r(31, 34)));
        RegionSetTest.assertFalse((boolean)regions.contains(RegionSetTest.r(15, 21)));
        RegionSetTest.assertFalse((boolean)regions.contains(RegionSetTest.r(13, 17)));
        RegionSetTest.assertFalse((boolean)regions.contains(RegionSetTest.r(0, 5)));
        RegionSetTest.assertFalse((boolean)regions.contains(RegionSetTest.r(31, 35)));
        regions.add(RegionSetTest.r(1, 69));
        RegionSetTest.assertTrue((boolean)regions.contains(RegionSetTest.r(1, 68)));
    }

    public void testIterator() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(25, 30), RegionSetTest.r(15, 20), RegionSetTest.r(5, 10));
        int count = this.countRegions(regions);
        RegionSetTest.assertEquals((int)3, (int)count);
    }

    public void testSinglePosition() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(10, 10));
        RegionSetTest.assertTrue((boolean)regions.contains(10));
    }

    public void testAddOverlappingRegions() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(10, 12), RegionSetTest.r(9, 11));
        RegionSetTest.assertFalse((boolean)regions.contains(8));
        RegionSetTest.assertTrue((boolean)regions.contains(9));
        RegionSetTest.assertTrue((boolean)regions.contains(10));
        RegionSetTest.assertTrue((boolean)regions.contains(11));
        RegionSetTest.assertTrue((boolean)regions.contains(12));
        RegionSetTest.assertFalse((boolean)regions.contains(13));
    }

    public void testPositionCount() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(10, 12));
        RegionSetTest.assertEquals((int)3, (int)regions.getPositionCount());
        regions.add(RegionSetTest.r(9, 11));
        RegionSetTest.assertEquals((int)4, (int)regions.getPositionCount());
    }

    public void testInvert() {
        RegionSet regions = RegionSetTest.set(RegionSetTest.r(2, 3), RegionSetTest.r(5, 6), RegionSetTest.r(10, 10));
        RegionSet invertedRegions = regions.createInverted("inverted", 10);
        RegionSetTest.assertNotNull((Object)invertedRegions);
        RegionSetTest.assertEquals((int)3, (int)invertedRegions.size());
        RegionSetTest.assertTrue((boolean)invertedRegions.contains(0));
        RegionSetTest.assertTrue((boolean)invertedRegions.contains(1));
        RegionSetTest.assertFalse((boolean)invertedRegions.contains(2));
        RegionSetTest.assertFalse((boolean)invertedRegions.contains(3));
        RegionSetTest.assertTrue((boolean)invertedRegions.contains(4));
        RegionSetTest.assertFalse((boolean)invertedRegions.contains(5));
        RegionSetTest.assertFalse((boolean)invertedRegions.contains(6));
        RegionSetTest.assertTrue((boolean)invertedRegions.contains(7));
        RegionSetTest.assertTrue((boolean)invertedRegions.contains(8));
        RegionSetTest.assertTrue((boolean)invertedRegions.contains(9));
        RegionSetTest.assertFalse((boolean)invertedRegions.contains(10));
        RegionSetTest.assertFalse((boolean)invertedRegions.contains(11));
    }

    public void testInvertSingleRegion() {
        RegionSet set = RegionSetTest.set(RegionSetTest.r(1, 2));
        RegionSet inverted = set.createInverted("inverted", 2);
        RegionSet original = inverted.createInverted("original", 2);
        RegionSetTest.assertEquals((int)1, (int)original.size());
        RegionSetTest.assertFalse((boolean)original.contains(0));
        RegionSetTest.assertTrue((boolean)original.contains(1));
        RegionSetTest.assertTrue((boolean)original.contains(2));
        RegionSetTest.assertFalse((boolean)original.contains(3));
    }

    public void testGetLastPosition() {
        RegionSet regionSet = RegionSetTest.set(RegionSetTest.r(1, 2));
        RegionSetTest.assertEquals((int)2, (int)regionSet.getLastPosition());
        regionSet.add(RegionSetTest.r(1, 2));
        RegionSetTest.assertEquals((int)2, (int)regionSet.getLastPosition());
        regionSet.add(RegionSetTest.r(1, 1));
        RegionSetTest.assertEquals((int)2, (int)regionSet.getLastPosition());
        regionSet.add(RegionSetTest.r(1, 3));
        RegionSetTest.assertEquals((int)3, (int)regionSet.getLastPosition());
        regionSet.add(RegionSetTest.r(9, 9));
        RegionSetTest.assertEquals((int)9, (int)regionSet.getLastPosition());
        regionSet.add(RegionSetTest.r(0, 1000));
        RegionSetTest.assertEquals((int)1000, (int)regionSet.getLastPosition());
    }

    public void testGetFirstPosition() {
        RegionSet regionSet = RegionSetTest.set(RegionSetTest.r(10, 20));
        RegionSetTest.assertEquals((int)10, (int)regionSet.getFirstPosition());
        regionSet.add(RegionSetTest.r(10, 20));
        RegionSetTest.assertEquals((int)10, (int)regionSet.getFirstPosition());
        regionSet.add(RegionSetTest.r(21, 25));
        RegionSetTest.assertEquals((int)10, (int)regionSet.getFirstPosition());
        regionSet.add(RegionSetTest.r(5, 8));
        RegionSetTest.assertEquals((int)5, (int)regionSet.getFirstPosition());
        regionSet.add(RegionSetTest.r(5, 50));
        RegionSetTest.assertEquals((int)5, (int)regionSet.getFirstPosition());
        regionSet.add(RegionSetTest.r(1, 2));
        RegionSetTest.assertEquals((int)1, (int)regionSet.getFirstPosition());
        regionSet.add(RegionSetTest.r(0, 2));
        RegionSetTest.assertEquals((int)0, (int)regionSet.getFirstPosition());
    }

    public static Region r(int start, int end) {
        return new Region(start, end);
    }

    public static RegionSet set(Region ... regions) {
        RegionSet regionSet = new RegionSet();
        Region[] regionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            Region region = regionArray[n2];
            regionSet.add(region);
            ++n2;
        }
        return regionSet;
    }

    public void testPositionsDontEqualForNull() {
        RegionSetTest.assertFalse((boolean)RegionSetTest.set(RegionSetTest.r(1, 2)).positionsEqual(null));
    }

    public void testPositionsEqualForEmptySets() {
        RegionSetTest.assertTrue((boolean)RegionSetTest.set(new Region[0]).positionsEqual(RegionSetTest.set(new Region[0])));
    }

    public void testPositionsDontEqualDifferentSets() {
        RegionSetTest.assertFalse((boolean)RegionSetTest.set(RegionSetTest.r(1, 2)).positionsEqual(RegionSetTest.set(new Region[0])));
    }

    public void testPositionsEqual() {
        RegionSet set1 = RegionSetTest.set(RegionSetTest.r(1, 3));
        RegionSet set2 = RegionSetTest.set(RegionSetTest.r(1, 1), RegionSetTest.r(2, 3));
        RegionSetTest.assertTrue((boolean)set1.positionsEqual(set2));
    }
}

