/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.text.MessageFormat;
import junit.framework.TestCase;
import org.conqat.lib.commons.string.MessageFormatUtils;

public class MessageFormatUtilsTest
extends TestCase {
    public void testNullEscape() {
        String input = null;
        String output = MessageFormatUtils.escapeString(input);
        MessageFormatUtilsTest.assertNull((Object)output);
    }

    public void testEasy() {
        String input = "This is a string that per se does not need escaping";
        String output = MessageFormatUtils.escapeString(input);
        MessageFormatUtilsTest.assertEquals((String)input, (String)output);
    }

    public void testApostropheEscape() {
        String input = "'";
        String output = MessageFormatUtils.escapeString(input);
        MessageFormatUtilsTest.assertEquals((String)"''", (String)output);
    }

    public void testMessageFormatUtils() {
        String input = "Some 'difficult' string to {parse!";
        String escapedString = MessageFormatUtils.escapeString(input);
        try {
            MessageFormat.format(input, "");
            MessageFormatUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MessageFormatUtilsTest.assertNotNull((Object)MessageFormat.format(escapedString, ""));
    }

    public void testNeutrality() {
        String input = "That's a tough unit test";
        String output = MessageFormat.format(MessageFormatUtils.escapeString(input), "");
        MessageFormatUtilsTest.assertEquals((String)output, (String)input);
    }
}

