/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import junit.framework.TestCase;
import org.conqat.lib.commons.string.IRegexReplacement;
import org.conqat.lib.commons.string.RegexReplacement;
import org.conqat.lib.commons.string.RegexReplacementProcessor;
import org.conqat.lib.commons.string.StringUtils;

public class RegexReplacementProcessorTest
extends TestCase {
    private RegexReplacementProcessor processor;

    public void testEmptyRegexList() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        String test = "test";
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"test", (String)this.processor.process(test));
    }

    public void testSimpleDelete() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("e"));
        String test = "test";
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"tst", (String)this.processor.process(test));
    }

    public void testMultiDelete() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("e"));
        regexes.add(new RegexReplacement("s"));
        String test = "test";
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"tt", (String)this.processor.process(test));
    }

    public void testSimpleReplace() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("e", "x"));
        String test = "test";
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"txst", (String)this.processor.process(test));
    }

    public void testSimpleReplaceWithCapturingGroup() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("//(.*)", "xx$1"));
        String test = "test3 // test4";
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"test3 xx test4", (String)this.processor.process(test));
    }

    public void testSimpleReplaceWithIllegalCapturingGroup() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("//.*", "xx$1"));
        String test = "test3 // test4";
        this.processor = new RegexReplacementProcessor(regexes);
        try {
            this.processor.process(test);
            RegexReplacementProcessorTest.fail();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public void testMultiReplace() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("e", "x"));
        regexes.add(new RegexReplacement("s", "u"));
        String test = "test";
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"txut", (String)this.processor.process(test));
    }

    public void testMultiReplaceWithOrder() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("e", "x"));
        regexes.add(new RegexReplacement("x", "u"));
        String test = "test";
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"tust", (String)this.processor.process(test));
    }

    public void testCaseSensitiveness() {
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("E"));
        String test = "test";
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"test", (String)this.processor.process(test));
        regexes.clear();
        regexes.add(new RegexReplacement("(?i)E"));
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"tst", (String)this.processor.process(test));
    }

    public void testMultiLineDelete() {
        Object[] testArray = new String[]{"test1/** test 3", "test4 */test2"};
        String test = StringUtils.concat(testArray, StringUtils.CR);
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("(?s)\\Q/**\\E.*\\Q*/\\E"));
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"test1test2", (String)this.processor.process(test));
    }

    public void testMultiLineReplace() {
        Object[] testArray = new String[]{"test1/** test 3", "test4 */test2"};
        String test = StringUtils.concat(testArray, StringUtils.CR);
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("(?s)\\Q/**\\E.*\\Q*/\\E", "y"));
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)"test1ytest2", (String)this.processor.process(test));
    }

    public void testMultiLineReplaceWithCapturingGroup() {
        Object[] testArray = new String[]{"test1/** test 3", "test4 */test2"};
        String test = StringUtils.concat(testArray, StringUtils.CR);
        ArrayList<IRegexReplacement> regexes = new ArrayList<IRegexReplacement>();
        regexes.add(new RegexReplacement("(?s)\\Q/**\\E(.*)\\Q*/\\E", "$1"));
        this.processor = new RegexReplacementProcessor(regexes);
        RegexReplacementProcessorTest.assertEquals((String)("test1 test 3" + StringUtils.CR + "test4 test2"), (String)this.processor.process(test));
    }
}

