/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.LineSplitter;

public class StringUtils {
    public static final String CR = System.getProperty("line.separator");
    public static final String EMPTY_STRING = "";
    public static final String LINE_TERMINATOR_SYMBOL = "\\n";
    public static final String SPACE = " ";
    public static final char SPACE_CHAR = ' ';
    public static final String TAB = "\t";
    public static final String TWO_SPACES = "  ";
    private static NumberFormat numberFormat = NumberFormat.getInstance();
    private static NumberFormat percentageFormat = NumberFormat.getPercentInstance();
    private static final Random random = new Random();

    public static String addRandomLineBreaks(String text, int count) {
        StringBuilder result = new StringBuilder(text);
        int len = text.length();
        int i = 0;
        while (i < count) {
            int pos = random.nextInt(len);
            result.insert(pos, CR);
            ++i;
        }
        return result.toString();
    }

    public static String center(String string, int length, char c) {
        if (string.length() >= length) {
            return string;
        }
        int strLen = string.length();
        int fillLen = (length - strLen) / 2;
        String leftFiller = StringUtils.fillString(fillLen, c);
        if ((length - strLen) % 2 != 0) {
            ++fillLen;
        }
        String rightFiller = StringUtils.fillString(fillLen, c);
        return String.valueOf(leftFiller) + string + rightFiller;
    }

    public static String concat(Iterable<?> iterable) {
        return StringUtils.concat(iterable, SPACE);
    }

    public static String concat(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return EMPTY_STRING;
        }
        if (separator == null) {
            separator = EMPTY_STRING;
        }
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String concat(Object[] array) {
        return StringUtils.concat(array, SPACE);
    }

    public static String concat(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.concat(Arrays.asList(array), separator);
    }

    public static String[] concat(String[] array1, String[] array2) {
        String[] result = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static String fillString(int length, char c) {
        char[] characters = new char[length];
        Arrays.fill(characters, c);
        return new String(characters);
    }

    public static String flushLeft(String string, int length, char c) {
        int gap = length - string.length();
        if (gap <= 0) {
            return string;
        }
        return String.valueOf(string) + StringUtils.fillString(gap, c);
    }

    public static String flushRight(String string, int length, char c) {
        int gap = length - string.length();
        if (gap <= 0) {
            return string;
        }
        return String.valueOf(StringUtils.fillString(gap, c)) + string;
    }

    public static String format(Number number) {
        return numberFormat.format(number);
    }

    public static String formatAsPercentage(Number number) {
        return percentageFormat.format(number);
    }

    public static String getFirstLine(String string) {
        LineSplitter lineSplitter = new LineSplitter();
        lineSplitter.setContent(string);
        return lineSplitter.getNextLine();
    }

    public static String getFirstParts(String string, int partNumber, char separator) {
        if (partNumber < 0 || string == null) {
            return string;
        }
        int idx = 0;
        int i = 0;
        while (i < partNumber) {
            if ((idx = string.indexOf(separator, idx + 1)) == -1) {
                return string;
            }
            ++i;
        }
        return string.substring(0, idx);
    }

    public static HashMap<String, String> getKeyValuePairs(String keyValueString) {
        String[] pairs;
        if (keyValueString == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (keyValueString.trim().equals(EMPTY_STRING)) {
            return result;
        }
        String[] stringArray = pairs = keyValueString.split(",");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            int index = pair.indexOf(61);
            if (index < 0) {
                result.put(pair.trim(), null);
            } else {
                String key = pair.substring(0, index).trim();
                String value = pair.substring(index + 1).trim();
                result.put(key, value);
            }
            ++n2;
        }
        return result;
    }

    public static String getLastPart(String string, char separator) {
        int idx = string.lastIndexOf(separator);
        if (idx >= 0) {
            return string.substring(idx + 1);
        }
        return string;
    }

    public static int indexOf(String[] array, String string) {
        int i = 0;
        while (i < array.length) {
            if (array[i].trim().equals(string.trim())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isEmpty(String text) {
        if (text == null) {
            return true;
        }
        return EMPTY_STRING.equals(text.trim());
    }

    public static String randomString(int length) {
        return StringUtils.randomString(length, random);
    }

    private static String randomString(int length, Random random) {
        char[] characters = new char[length];
        int i = 0;
        while (i < length) {
            characters[i] = (char)(random.nextInt(93) + 33);
            ++i;
        }
        return new String(characters);
    }

    public static String[] randomStringArray(int length, int stringLength) {
        String[] array = new String[length];
        int i = 0;
        while (i < length) {
            array[i] = StringUtils.randomString(stringLength);
            ++i;
        }
        return array;
    }

    public static String generateString(int length, int seed) {
        Random seededRandomizer = new Random(seed);
        return StringUtils.randomString(length, seededRandomizer);
    }

    public static String[] generateStringArray(int length, int stringLength, int seed) {
        String[] array = new String[length];
        int i = 0;
        while (i < length) {
            array[i] = StringUtils.generateString(stringLength, seed + i);
            ++i;
        }
        return array;
    }

    public static String removeLastPart(String string, char separator) {
        int idx = string.lastIndexOf(separator);
        if (idx == -1) {
            return string;
        }
        return string.substring(0, idx);
    }

    public static String replaceLineBreaks(String string) {
        return StringUtils.replaceLineBreaks(string, LINE_TERMINATOR_SYMBOL);
    }

    public static String normalizeLineBreaks(String string) {
        return StringUtils.replaceLineBreaks(string, CR);
    }

    public static String replaceLineBreaks(String string, String symbol) {
        symbol = symbol.replaceAll("\\\\", "\\\\\\\\");
        symbol = symbol.replaceAll("\\$", "\\\\\\$");
        return string.replaceAll("\\r\\n|\\n\\r|\\r|\\n", symbol);
    }

    public static String[] splitLines(String content) {
        List<String> lineList = StringUtils.splitLinesAsList(content);
        String[] result = new String[lineList.size()];
        lineList.toArray(result);
        return result;
    }

    public static List<String> splitLinesAsList(String content) {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        LineSplitter lineSplitter = new LineSplitter();
        lineSplitter.setContent(content);
        while ((line = lineSplitter.getNextLine()) != null) {
            result.add(line);
        }
        return result;
    }

    public static String stripPrefix(String prefix, String string) {
        if (string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String stripSuffix(String suffix, String string) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String stripDigits(String string) {
        return string.replaceAll("[0-9]", EMPTY_STRING);
    }

    public static String toString(Map<?, ?> map) {
        return StringUtils.toString(map, EMPTY_STRING);
    }

    public static String toString(Map<?, ?> map, String indent) {
        StringBuilder result = new StringBuilder();
        Iterator<?> keyIterator = map.keySet().iterator();
        while (keyIterator.hasNext()) {
            result.append(indent);
            Object key = keyIterator.next();
            result.append(key);
            result.append(" = ");
            result.append(map.get(key));
            if (!keyIterator.hasNext()) continue;
            result.append(CR);
        }
        return result.toString();
    }

    public static String obtainStackTrace(Throwable throwable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        throwable.printStackTrace(printWriter);
        return result.toString();
    }

    public static boolean startsWithOneOf(String string, String ... prefixes) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (string.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsOneOf(String text, String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (text.contains(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean endsWithOneOf(String string, String ... suffixes) {
        String[] stringArray = suffixes;
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (string.endsWith(suffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String prefixLines(String string, String prefix, boolean prefixFirstLine) {
        String[] lines = StringUtils.splitLines(string.trim());
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            if (i > 0 || prefixFirstLine) {
                result.append(prefix);
            }
            result.append(lines[i]);
            if (i < lines.length - 1) {
                result.append(CR);
            }
            ++i;
        }
        return result.toString();
    }

    public static Character[] splitChars(String s) {
        Character[] result = new Character[s.length()];
        int i = 0;
        while (i < result.length) {
            result[i] = Character.valueOf(s.charAt(i));
            ++i;
        }
        return result;
    }

    public static String capitalize(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }

    public static String wrapLongLines(String s, int maxLineLength) {
        String[] words = s.split("\\s+");
        StringBuilder sb = new StringBuilder();
        int lineLength = 0;
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.length() != 0) {
                if (lineLength > 0) {
                    if (lineLength + 1 + word.length() > maxLineLength) {
                        sb.append(CR);
                        lineLength = 0;
                    } else {
                        sb.append(SPACE);
                        ++lineLength;
                    }
                }
                sb.append(word);
                lineLength += word.length();
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String longestCommonPrefix(String s, String t) {
        int n = Math.min(s.length(), t.length());
        int i = 0;
        while (i < n) {
            if (s.charAt(i) != t.charAt(i)) {
                return s.substring(0, i);
            }
            ++i;
        }
        return s.substring(0, n);
    }

    public static String longestCommonPrefix(Iterable<String> strings) {
        Iterator<String> iterator = strings.iterator();
        CCSMAssert.isTrue(iterator.hasNext(), "Expected are at least 2 strings");
        String commonPrefix = iterator.next();
        CCSMAssert.isTrue(iterator.hasNext(), "Expected are at least 2 strings");
        while (iterator.hasNext()) {
            if ((commonPrefix = StringUtils.longestCommonPrefix(commonPrefix, iterator.next())).length() == 0) break;
        }
        return commonPrefix;
    }

    public static String removeWhitespace(String content) {
        return content.replaceAll("\\s", EMPTY_STRING);
    }

    public static String createUniqueName(String baseName, Set<String> usedNames) {
        String name = baseName;
        int i = 1;
        while (usedNames.contains(name)) {
            name = String.valueOf(baseName) + ++i;
        }
        return name;
    }

    public static String camelCaseToHyphenated(String s) {
        return s.replaceAll("([^^])([A-Z][a-z])", "$1-$2").toLowerCase();
    }

    public static String encodeAsHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X", b & 0xFF));
            ++n2;
        }
        return sb.toString();
    }

    public static byte[] decodeFromHex(String s) {
        byte[] result = new byte[s.length() / 2];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return result;
    }

    public static String format(double number, NumberFormat numberFormat) {
        if (numberFormat == null) {
            return String.valueOf(number);
        }
        return numberFormat.format(number);
    }

    public static String escapeRegexReplacementString(String replacement) {
        return replacement.replaceAll("([$\\\\])", "\\\\$1");
    }

    public static byte[] stringToBytes(String s) {
        return s.getBytes(FileSystemUtils.UTF8_CHARSET);
    }

    public static String bytesToString(byte[] b) {
        return new String(b, FileSystemUtils.UTF8_CHARSET);
    }
}

