/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.List;
import org.conqat.lib.commons.string.StringUndoStackBase;
import org.conqat.lib.commons.string.StringUtils;

class UndoStack
extends StringUndoStackBase {
    private int stackChangeCounter = 0;
    private final StringBuilder model = new StringBuilder();

    public UndoStack(String initialString) {
        super(initialString);
        this.model.append(initialString);
    }

    @Override
    protected void fireStackChanged() {
        ++this.stackChangeCounter;
    }

    @Override
    protected String join(List<String> parts) {
        return StringUtils.concat(parts, StringUtils.CR);
    }

    @Override
    protected List<String> split(String s) {
        return StringUtils.splitLinesAsList(s);
    }

    @Override
    protected void setModelFromString(String s) {
        this.model.setLength(0);
        this.model.append(s);
    }

    public String getModel() {
        return this.model.toString();
    }

    public void addLine(String line) {
        if (this.model.length() > 0) {
            this.model.append(StringUtils.CR);
        }
        this.model.append(line);
        this.insertNewVersion(this.model.toString());
    }

    public int getStackChangeCount() {
        return this.stackChangeCounter;
    }
}

