/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.system;

import java.util.Timer;
import java.util.TimerTask;

public class MemoryMonitor {
    private static final int DEFAULT_PERIOD = 50;
    private Timer timer;
    private final int period;
    private final MemoryMonitorTask monitorTask = new MemoryMonitorTask();

    public MemoryMonitor() {
        this(50);
    }

    public MemoryMonitor(int period) {
        this.period = period;
        this.timer = new Timer(true);
    }

    public void start() {
        this.timer.schedule((TimerTask)this.monitorTask, 0L, (long)this.period);
    }

    public void stop() {
        this.timer.cancel();
        this.timer = new Timer(true);
    }

    public void reset() {
        this.monitorTask.reset();
    }

    public long getMaximumMemoryUsage() {
        return this.monitorTask.getMaximumMemoryUsage();
    }

    private static class MemoryMonitorTask
    extends TimerTask {
        private final Runtime runtime = Runtime.getRuntime();
        private long maxMemory = 0L;

        @Override
        public void run() {
            long usedMemory = this.runtime.totalMemory();
            if (usedMemory > this.maxMemory) {
                this.maxMemory = usedMemory;
            }
        }

        public long getMaximumMemoryUsage() {
            return this.maxMemory;
        }

        public void reset() {
            this.maxMemory = 0L;
        }
    }
}

